/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.nexaweb.parser;

import java.util.Vector;

/**
 * <p>[概 要] </p>
 * エレメントの値を保持するElementValueオブジェクトを集約するクラスです。
 * 
 * <p>[詳 細] </p>
 * textFieldやcomboBoxは単一の値を保持しますが、マルチセレクタブルな
 * listBoxエレメントや、マトリクスデータを扱うtableエレメントは、複数の
 * 値を保持します。<BR>
 * その場合、一つの値（「name属性=値」）を持つElementValueオブジェクトを
 * このElementValuesが集約する形で保持します。
 * 
 * <p>[備 考] </p>
 * ElementValueはnameフィールドを持ち、大抵の場合、エレメントが複数の値を
 * 持つ場合でもnameフィールドの値は変わりません。
 * <P>
 * 
 * 但し、tableエレメントの場合はnameフィールドが変わります。
 * <PRE>
 * 	&lt;table height="200px" id="table" name="dataTable" quickEdit="true"
 *		width="300px" x="40px" y="330px"&gt;
 *
 *		&lt;column&gt;
 *			&lt;header text="姓名"/&gt;
 *		&lt;/column&gt;
 *		&lt;column&gt;
 *			&lt;header text="年齢"/&gt;
 *		&lt;/column&gt;
 *		&lt;row&gt;
 *			&lt;cell name="name" editable="true" text="山田太郎"/&gt;
 *			&lt;cell name="age" editable="true" text="32"/&gt;
 *		&lt;/row&gt;
 *		&lt;row&gt;
 *			&lt;cell name="name" editable="true" text="鈴木一郎"/&gt;
 *			&lt;cell name="age" editable="true" text="25"/&gt;
 *		&lt;/row&gt;
 *	&lt;/table&gt;
 * </PRE>
 * 上記のテーブル定義の場合、
 * 
 * <PRE>
 * Parser parser = new ElementValueParser();
 * ElementValues values = parser.parse(table);
 * </PRE>
 * 戻り値valuesは以下のような構造になり、４つの名前と値を持ちます。
 * 
 * <PRE>
 * 	ElementValues[
 * 		ElementValue[
 * 			name = "dataTable[0].name"
 * 			value = "山田太郎"
 * 		]
 * 		ElementValue[
 * 			name = "dataTable[0].age"
 * 			value = "32"
 * 		]
 * 		ElementValue[
 * 			name = "dataTable[1].name"
 * 			value = "鈴木一郎"
 * 		]
 * 		ElementValue[
 * 			name = "dataTable[1].age"
 * 			value = "25"
 * 		]
 * 	}
 * </PRE>
 * 
 * <p>[環 境] JDK 6.0 Update 11</p>
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @author Project Reffi
 */
public class ElementValues {

	/** 単一の値を持つElementValueオブジェクトの集約です。 */
	private Vector<ElementValue> elementValues;

	/** 
	 * <p>[概 要] </p>
	 * このオブジェクトが何個のElementValueオブジェクトを保有しているか返却します。
	 * 
	 * <p>[詳 細] </p>
	 * elementValuesフィールドのサイズを取得して返却します。
	 * 
	 * <p>[備 考] </p>
	 *
	 * @return このオブジェクトが保持するElementValueオブジェクトの数
	 */
	public int size() {
		return this.elementValues.size();
	}

	/**
	 * <p>[概 要] </p>
	 * 単一の値を持つElementValueオブジェクトを追加します。
	 * 
	 * <p>[詳 細] </p>
	 * elementValuesフィールドに引数elementValueを追加します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param elementValue ElementValueオブジェクト
	 */
	public void addElementValue(ElementValue elementValue) {
		this.elementValues.add(elementValue);
	}

	/**
	 * <p>[概 要] </p>
	 * 単一の値を持つElementValueオブジェクトを返却します。
	 * 
	 * <p>[詳 細] </p>
	 * elementValuesフィールドの引数index番目を取得して返却します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param index 保持インデックス
	 * @return ElementValueオブジェクト
	 */
	public ElementValue getElementValue(int index) {
		return elementValues.get(index);
	}

	/**
	 * <p>[概 要] </p>
	 * デフォルトコンストラクタです。
	 * 
	 * <p>[詳 細] </p>
	 * ElementValueオブジェクトを集約するベクタ領域を生成します。 
	 * 
	 * <p>[備 考] </p>
	 */
	public ElementValues() {
		this.elementValues = new Vector<ElementValue>();
	}
}
