/*
 * Decompiled with CFR 0.152.
 */
package jp.recnavi.epg.site;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.recnavi.epg.site.AbstructWebPage;
import jp.recnavi.epg.site.ONTVDistrict;

public class ONTVArea
extends AbstructWebPage {
    private ArrayList<String> districtNames = new ArrayList();
    private Hashtable<String, ONTVDistrict> districts = new Hashtable();

    ONTVArea() {
    }

    protected String getURL() {
        return "http://www.ontvjapan.com/areachange/areaselect.php3?tv=1&force=1";
    }

    void clear() {
        this.districtNames.clear();
        this.districts.clear();
    }

    void add(ONTVDistrict district) {
        String name = district.getName();
        this.districtNames.add(name);
        this.districts.put(name, district);
    }

    private void setONTVDistricts(String html) {
        this.clear();
        Pattern pattern = Pattern.compile("<TR>\\s*<TD[^>]*>\\s*([^<]+)\\s*</TD>\\s*<TD>(.*?)</TR>", 32);
        Matcher matcher = pattern.matcher(html);
        while (matcher.find()) {
            String districtName = matcher.group(1);
            String prefecturesHtml = matcher.group(2);
            ONTVDistrict district = new ONTVDistrict(districtName);
            district.setONTVPrefectures(prefecturesHtml);
            this.add(district);
        }
    }

    public void update() {
        this.setONTVDistricts(this.getHTML());
    }

    Object[] getONTVDistrictNames() {
        return this.districtNames.toArray();
    }

    ONTVDistrict getONTVDistrict(String name) {
        return this.districts.get(name);
    }
}

