/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.opensymphony.xwork2.util.ValueStack;

import org.apache.struts2.components.Component;

import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScope;
import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScopeAware;


/**
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: SetReturn.java 3 2009-07-30 18:02:43Z takahashikzn $
 */
public class SetReturn
    extends SetLocal {

    /**
     * @param stack
     * stack
     */
    public SetReturn(final ValueStack stack) {
        super(stack);
    }

    /** {@inheritDoc} */
    @Override
    protected LocalVariableScope getEnclosingLocalVariableScope() {
        @SuppressWarnings("unchecked")
        final List<Component> componentStack =
            new ArrayList<Component>(this.getComponentStack());

        Collections.reverse(componentStack);

        // 最初のMergeComponentの次に来るBlockを探す。
        boolean mergeComponentFound = false;
        for (final Component comp : componentStack) {
            if (mergeComponentFound) {
                if (comp instanceof LocalVariableScopeAware) {
                    return ((LocalVariableScopeAware) comp)
                        .getLocalVariableScope();
                }
            } else if (comp instanceof MergeComponent) {
                mergeComponentFound = true;
            }
        }

        throw new IllegalStateException("<r:merge-component> not found: "
            + componentStack);
    }
}
