/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.jsptags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.util.ValueStack;

import org.apache.struts2.views.jsp.ContextBeanTag;

import jp.root42.r42fw.export.web.ui.components.SetLocal;


/**
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: SetLocalTag.java 16 2009-10-31 10:08:10Z takahashikzn $
 */
public class SetLocalTag
    extends ContextBeanTag {

    /** {@link #serialVersionUID} */
    private static final long serialVersionUID = 5779567546073555493L;

    /***/
    private String value;

    /***/
    private boolean evalBody;

    /** {@inheritDoc} */
    @Override
    public SetLocal getBean(final ValueStack stack,
        final HttpServletRequest req, final HttpServletResponse res) {
        return new SetLocal(stack);
    }

    /** {@inheritDoc} */
    @Override
    protected void populateParams() {
        super.populateParams();

        ((SetLocal) this.getComponent()).setValue(this.value);
        ((SetLocal) this.getComponent()).setEvalBody(this.evalBody);
    }

    /**
     * @param value
     * value
     */
    public void setValue(final String value) {
        this.value = value;
    }

    /**
     * @param evalBody
     * evalBody
     */
    public void setEvalBody(final boolean evalBody) {
        this.evalBody = evalBody;
    }
}
