<?php
class datasets_base extends myQuicty {

function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 1800; // cache life time by seconds
	$this->cache_id = get_query_id();
	$this->page['base_url'] = quicty_base_url();
	
	$this->application['id'] = $_REQUEST['application_id'] ? $_REQUEST['application_id'] : NULL;
	if(!in_array($this->dispatch_action,array('info','edit','delete','write_conf','create_table','create_template')) and !$this->application['id'])
		redirect('/');
	return true;
}

function assign_search_form() {
	$search_form = $this->new_search_obj('datasets_search',array('action'=>$this->page['base_url'].'/datasets/','method'=>'get'));
	$this->assign_form('search_form',$search_form);
}

function list_records() {
	require_once 'list_options.class.php';
	$this->list = $this->new_data_set('datasets');
	$options = new datasets_list_options($this);
	$pager_option = $options->get_pager_option();
	$this->list->bind_pager($pager_option);
	
	$fields = $options->make_select_fields();
	$sort_condition = $options->make_sort_condition();
	$table = $this->list->select_table_with_pager($sort_condition,$fields);
	
	$this->assign('table_view',$this->list->display_table_value($table));
	$this->assign('display_cmd','info');
	$this->page['pager'] = $this->list->get_pager_links();
}


function display_record($condition='') {
	require_once 'form_options.class.php';
	$this->form = $this->new_data_set('datasets');
	$options = new datasets_form_options($this);
	$options->set_form_options();
	$options->set_form_filters();
	$this->form->validate_and_freeze();
	$this->form->bind_button_control();
	
	$result = $this->form->automatic_form_handler($condition);
	$this->datasets = $result['datasets'] ? $result['datasets'] : $result['values'];
	
	$this->assign_form('input_form',$this->form);
	$this->assign('datasets',$this->datasets);
}




} // end of datasets_base class
?>