package org.qrone.xmlsocket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public abstract class SelectorServerSocket implements ExceptionListener {
	protected SelectorThread thread;
	protected ServerSocketChannel serverchannel;

	public SelectorServerSocket(SelectorThread thread) {
		this.thread = thread;
	}

	public void open(int port){
		try{
			serverchannel = ServerSocketChannel.open();
			InetSocketAddress isa = new InetSocketAddress(port);
			serverchannel.socket().bind(isa, 100);
	
			thread.register(serverchannel, SelectionKey.OP_ACCEPT, this);
			onOpen(true);
		}catch(IOException e){
			onOpen(false);
			onError(e);
		}
	}
	
	public void close(){
		try {
			serverchannel.close();
		} catch (IOException e) {}
		onClose();
	}

	public void accept(){
		try{
			SocketChannel channel = serverchannel.accept();
			if (channel != null) {
				SelectorSocket socket = createSelectorSocket();
				socket.connect(channel);
				onNewClient(socket);
				socket.onConnect(true);
			}
		} catch (IOException e){
			close();
			onError(e);
		}
	}

	public ServerSocketChannel getServerSocketChannel() {
		return serverchannel;
	}

	public abstract SelectorSocket createSelectorSocket();
	
	public abstract void onOpen(boolean success);
	
	public abstract void onClose();
	
	public abstract void onNewClient(SelectorSocket socket);

	public abstract void onError(Exception e);
}
