package org.qrone.xmlsocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;

import org.apache.log4j.Logger;
import org.qrone.XMLTools;
import org.qrone.xmlsocket.event.XMLSocketListener;
import org.qrone.xmlsocket.inner.XMLSocketProtocolDecoder;
import org.qrone.xmlsocket.inner.XMLSocketProtocolEncoder;
import org.qrone.xmlsocket.nio.ExceptionListener;
import org.qrone.xmlsocket.nio.SelectorSocket;
import org.qrone.xmlsocket.nio.SelectorThread;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLSocketNIO extends SelectorSocket{
	private static final Logger log = Logger.getLogger(XMLSocketNIO.class);
	
	public XMLSocketNIO() throws IOException {
		this(new SelectorThread(new ExceptionListener(){
				public void onError(Exception e) {
					onError(e);
				}
			}));
	}
	public XMLSocketNIO(SelectorThread thread) {
		super(thread, 
				new XMLSocketProtocolEncoder(), 
				new XMLSocketProtocolDecoder());
	}
	private boolean parsexml = true;
	private LinkedList xmllistener = new LinkedList();
	
	private Charset inputcs  = Charset.forName("UTF-8");
	private Charset outputcs = Charset.forName("UTF-8");
	private String ipaddress = "";
	
	public void setEncoding(Charset cs){
		setEncoding(cs,cs);
	}
	
	public void setEncoding(String charset){
		setEncoding(Charset.forName(charset));
	}
	
	public void setEncoding(Charset input, Charset output){
		inputcs = input;
		outputcs = output;
	}
	
	/**
	 *  str 𑊎葤ɑ܂B XMLSocket ʐMł str ͒ʏ well-formed XML
	 * ł Kv܂B
	 * 
	 * @param str M镶 iXML łׂłj
	 */
	public void send(String str) {
		try {
			send(str.getBytes(outputcs.displayName()));
			log.debug("SEND " + ipaddress + " " + str);
		} catch (UnsupportedEncodingException e) {}
	}

	/**
	 * XML hLg𑊎葤ɑ܂B
	 * 
	 * @param doc M XML hLg
	 */
	public void send(Document doc) throws TransformerException {
		Transformer t = XMLTools.transformerFactory.newTransformer();
		t.setOutputProperty(OutputKeys.ENCODING,outputcs.displayName());
		String str = XMLTools.write(doc,t);
		try {
			send(str.getBytes(outputcs.displayName()));
			log.debug("SEND " + ipaddress + " " + str);
		} catch (UnsupportedEncodingException e) {}
	}

	/**
	 * XML ͂sǂ̐ݒ܂Btrue ɂꍇɂ͏ XML ͂s ܂A
	 * false ɂ XML
	 * ͂sȂȂAonXML(Document) Ăяo 邱ƂȂȂ܂B
	 * 
	 * @param bool
	 *            XML ͂̍s/sȂ
	 */
	public void setXMLParsing(boolean bool) {
		parsexml = bool;
	}

	/**
	 * ڑsĂ Socket NX̃CX^XԂ܂B
	 * 
	 * @return ڑ\Pbg
	 */
	public Socket getSocket() {
		return getSocketChannel().socket();
	}

	/**
	 * ڑJnɌĂ΂AXMLSocketListener ɒʒm܂Bsuccess == false ̎
	 * <b>ʐMmĂ܂B</b>
	 * ̏ꍇɂ͒ʏ onError Ă΂܂B<BR>
	 * <BR>
	 * ̃NXpNXꍇɂ͂̃\bhp邱Ƃ onConnect(boolean) Cxg 
	 * 擾ł܂B
	 * 
	 * @param success
	 *            ڑ̐
	 */
	public void onConnect(boolean success) {
		ipaddress = getSocket().getInetAddress().getHostAddress();
		for (Iterator iter = xmllistener.iterator(); iter.hasNext();) {
			((XMLSocketListener) iter.next()).onConnect(success);
		}
		if(success) log.debug("CONNECT " + ipaddress);
	}

	/**
	 * ؒfɌĂ΂AXMLSocketListener ɒʒm܂B<BR>
	 * <BR>
	 * ̃NXpNXꍇɂ͂̃\bhp邱Ƃ onClose() Cxg 擾ł܂
	 */
	public void onClose() {
		for (Iterator iter = xmllistener.iterator(); iter.hasNext();) {
			((XMLSocketListener) iter.next()).onClose();
		}
		log.debug("CLOSE " + ipaddress);
	}

	/**
	 * G[ɌĂ΂AXMLSocketListener ɒʒm܂B<BR>
	 * <BR>
	 * ̃NXpNXꍇɂ͂̃\bhp邱Ƃ onError(Exception) Cxg 
	 * 擾ł܂B
	 * 
	 * @param e
	 *            G[
	 */
	public void onError(Exception e) {
		for (Iterator iter = xmllistener.iterator(); iter.hasNext();) {
			((XMLSocketListener) iter.next()).onError(e);
		}
		log.debug("ERROR " + ipaddress,e);
	}

	/**
	 * ʐM^CAEgɌĂ΂AXMLSocketListener ɒʒm܂B^CAEg͒ʏRObx 
	 * ݒ肳Ă܂B<BR>
	 * <BR>
	 * ̃NXpNXꍇɂ͂̃\bhp邱Ƃ onTimeout() Cxg 
	 * 擾ł܂
	 * 
	 * @see java.net.Socket#setSoTimeout(int)
	 */
	public void onTimeout() {
		for (Iterator iter = xmllistener.iterator(); iter.hasNext();) {
			((XMLSocketListener) iter.next()).onTimeout();
		}
		log.debug("TIMEOUT " + ipaddress);
	}
	
	public void onPacket(byte[] b) {
		try {
			onData(new String(b,inputcs.displayName()));
		} catch (UnsupportedEncodingException e) {}
	}
	
	/**
	 * f[^MɌĂ΂AXMLSocketListener ɒʒmAXML ͂s onXML(Document) 
	 * Ăяo܂B<BR>
	 * <BR>
	 * ̃NXpNXꍇɂ͂̃\bhp邱Ƃ onData(String) Cxg
	 * 擾ł܂B̃\bhpꍇAsuper.onData(String) Ă΂Ȃ onXML(Document)
	 * CxgĂ΂ȂȂ܂B
	 * 
	 * @see #onXML(Document)
	 */
	protected void onData(String data) {
		for (Iterator iter = xmllistener.iterator(); iter.hasNext();) {
			((XMLSocketListener) iter.next()).onData(data);
		}
		log.debug("DATA " + ipaddress + data);
		try {
			onXML(XMLTools.read(data));
		} catch (SAXException e) {}
	}

	/**
	 * f[^M̂ XML ͌AɌĂ΂AXMLSocketListener ɒʒm܂B<BR>
	 * <BR>
	 * ̃NXpNXꍇɂ͂̃\bhp邱Ƃ onXML(Document) Cxg
	 * 擾ł܂B̃Cxg擾ɂ setXMLParseing(boolean)  true (default)
	 * ݒ肳ĂKv܂B
	 */
	protected void onXML(Document doc) {
		for (Iterator iter = xmllistener.iterator(); iter.hasNext();) {
			((XMLSocketListener) iter.next()).onXML(doc);
		}
	}

	/**
	 * Cxgnho^܂B̃\bh𗘗p XMLSocketListener NX
	 * o^ăCxg擾AKXsĂB
	 * 
	 * @param listener
	 *            Cxgnh
	 */
	public void addXMLSocketListener(XMLSocketListener listener) {
		xmllistener.add(listener);
	}

	/**
	 * o^Cxgnh폜܂B
	 * 
	 * @param listener
	 *            Cxgnh
	 */
	public void removeXMLSocketListener(XMLSocketListener listener) {
		xmllistener.remove(listener);
	}
}
