/*
 *  psychlops_g_shader.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/12/14 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_GRAPHIC_SHADER
#define HEADER_PSYCHLOPS_GRAPHIC_SHADER

#include <string>
#include <map>
#include "../../../core/graphic/psychlops_graphic.h"

namespace Psychlops {

	class ShaderAPI;
	class Shader
	{
	protected:
		ShaderAPI *api;
	public:
		typedef std::vector<std::string> Variables;
		Shader();
		~Shader();
		void cache(const std::string &orig_source, const std::vector<std::string> &vars, Drawable &target);
		void cacheField(const std::string &orig_source, const std::vector<std::string> &vars, Drawable &target);
		void cacheTex(const std::string &orig_source, const std::vector<std::string> &vars, Drawable &target, int sw = 0);
		void drawField(const Rectangle &rect, const double *argv, const int argn);
		void drawImage(Image &img, const double *argv, const int argn, Canvas &target);
		void drawImage(Image &img, const double *argv, const int argn, Image &arg_img, Canvas &target);
		void fieldToImage(Image &target, const Rectangle &rect, const double *argv, const int argn, Canvas &media);
		void imageToImage(Image &target, Image &img, const double *argv, const int argn, Canvas &media);
	};


}	/*	<- namespace Psycholops 	*/

#endif
