/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text;

import java.text.MessageFormat;
import java.util.HashMap;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.GotoMarkerAction;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.GroupByKeyComputer;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.TextSearchActionGroup;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.TextSearchOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.util.FileLabelProvider;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionGroup;

public class TextSearchResultCollector
implements ITextSearchResultCollector {
    private static final String DONE;
    private static final String MATCH;
    private static final String MATCHES;
    private long fLastUpdateTime;
    private int fMatchCount = 0;
    private Integer[] fMessageFormatArgs = new Integer[1];
    private IProgressMonitor fMonitor;
    private TextSearchOperation fOperation;
    private ISearchResultView fView;

    static {
        MATCH = SearchMessages.getString((String)"SearchResultCollector.match");
        MATCHES = SearchMessages.getString((String)"SearchResultCollector.matches");
        DONE = SearchMessages.getString((String)"SearchResultCollector.done");
    }

    public void aboutToStart() throws CoreException {
        this.fView = SearchUI.getSearchResultView();
        this.fMatchCount = 0;
        this.fLastUpdateTime = 0L;
        if (this.fView != null) {
            this.fView.searchStarted((IActionGroupFactory)new TextSearchActionGroupFactory(), this.fOperation.getSingularLabel(), this.fOperation.getPluralLabelPattern(), this.fOperation.getImageDescriptor(), "jp.gr.java_conf.ussiy.app.property.search.internal.ui.text.PropertySearchPage", (ILabelProvider)new FileLabelProvider(2), (IAction)new GotoMarkerAction(), (IGroupByKeyComputer)new GroupByKeyComputer(), (IRunnableWithProgress)this.fOperation);
        }
    }

    public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) throws CoreException {
        IResource resource = proxy.requestResource();
        IMarker marker = resource.createMarker("org.eclipse.search.searchmarker");
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("line", line);
        attributes.put("charStart", new Integer(start));
        attributes.put("charEnd", new Integer(start + length));
        attributes.put("lineNumber", new Integer(lineNumber));
        marker.setAttributes(attributes);
        String description = resource.getFullPath().lastSegment();
        if (description == null) {
            description = "";
        }
        this.fView.addMatch(description, (Object)resource, resource, marker);
        ++this.fMatchCount;
        if (!this.getProgressMonitor().isCanceled() && System.currentTimeMillis() - this.fLastUpdateTime > 1000L) {
            this.getProgressMonitor().subTask(this.getFormattedMatchesString(this.fMatchCount));
            this.fLastUpdateTime = System.currentTimeMillis();
        }
    }

    public void done() {
        if (!this.getProgressMonitor().isCanceled()) {
            String matchesString = this.getFormattedMatchesString(this.fMatchCount);
            this.getProgressMonitor().setTaskName(MessageFormat.format(DONE, matchesString));
        }
        if (this.fView != null) {
            this.fView.searchFinished();
        }
        this.fView = null;
        this.fMonitor = null;
    }

    private String getFormattedMatchesString(int count) {
        if (this.fMatchCount == 1) {
            return MATCH;
        }
        this.fMessageFormatArgs[0] = new Integer(count);
        return MessageFormat.format(MATCHES, this.fMessageFormatArgs);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    void setOperation(TextSearchOperation operation) {
        this.fOperation = operation;
    }

    void setProgressMonitor(IProgressMonitor pm) {
        this.fMonitor = pm;
    }

    private static class TextSearchActionGroupFactory
    implements IActionGroupFactory {
        private TextSearchActionGroupFactory() {
        }

        public ActionGroup createActionGroup(ISearchResultView part) {
            return new TextSearchActionGroup((IViewPart)part);
        }
    }
}

