/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.core.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.core.text.TypedResourceVisitor;
import jp.gr.java_conf.ussiy.app.propedit.util.EncodeChanger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.FileMatchCollector;
import org.eclipse.search.internal.core.text.IMatchCollector;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextSearchVisitor
extends TypedResourceVisitor {
    private ITextSearchResultCollector fCollector;
    private IEditorPart[] fEditors;
    private long fLastUpdateTime;
    private MatchLocator fLocator;
    private Integer[] fMessageFormatArgs;
    private int fNumberOfFilesToScan;
    private int fNumberOfScannedFiles;
    private IProgressMonitor fProgressMonitor;
    private ISearchScope fScope;
    private boolean fVisitDerived;
    protected static final int fgCR = 13;
    protected static final int fgLF = 10;

    public TextSearchVisitor(MatchLocator locator, ISearchScope scope, boolean visitDerived, ITextSearchResultCollector collector, MultiStatus status, int fileCount) {
        super(status);
        this.fScope = scope;
        this.fCollector = collector;
        this.fProgressMonitor = collector.getProgressMonitor();
        this.fLocator = locator;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = fileCount;
        this.fMessageFormatArgs = new Integer[]{new Integer(0), new Integer(fileCount)};
        this.fVisitDerived = visitDerived;
    }

    private ITextEditor findEditorFor(IFile file) {
        int i = 0;
        while (i < this.fEditors.length) {
            IEditorPart editor = this.fEditors[i];
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput && editor instanceof ITextEditor && ((IFileEditorInput)input).getFile().equals((Object)file)) {
                return (ITextEditor)editor;
            }
            ++i;
        }
        return null;
    }

    public static IEditorPart[] getEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorInput input;
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep != null && !inputs.contains(input = ep.getEditorInput())) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public void process(Collection projects) {
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            IProject project = (IProject)i.next();
            try {
                project.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                this.addToStatus(ex);
            }
        }
    }

    private boolean shouldVisit(IResourceProxy proxy) {
        if (!this.fScope.encloses(proxy)) {
            return false;
        }
        if (this.fVisitDerived) {
            return true;
        }
        return !proxy.isDerived();
    }

    private void updateProgressMonitor() {
        ++this.fNumberOfScannedFiles;
        if (this.fNumberOfScannedFiles < this.fNumberOfFilesToScan && System.currentTimeMillis() - this.fLastUpdateTime > 1000L) {
            this.fMessageFormatArgs[0] = new Integer(this.fNumberOfScannedFiles + 1);
            this.fProgressMonitor.setTaskName(SearchMessages.getFormattedString((String)"TextSearchVisitor.scanning", (Object[])this.fMessageFormatArgs));
            this.fLastUpdateTime = System.currentTimeMillis();
        }
        this.fProgressMonitor.worked(1);
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException(SearchMessages.getString((String)"TextSearchVisitor.canceled"));
        }
    }

    public boolean visit(IResourceProxy proxy) {
        this.fEditors = TextSearchVisitor.getEditors();
        return super.visit(proxy);
    }

    protected boolean visitFile(IResourceProxy proxy) throws CoreException {
        if (!this.shouldVisit(proxy)) {
            return false;
        }
        if (this.fLocator.isEmtpy()) {
            this.fCollector.accept(proxy, "", -1, 0, -1);
            this.updateProgressMonitor();
            return true;
        }
        IFile file = (IFile)proxy.requestResource();
        try {
            try {
                BufferedReader reader = null;
                ITextEditor editor = this.findEditorFor(file);
                if (editor != null) {
                    String s = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get();
                    reader = new BufferedReader(new StringReader(EncodeChanger.unicodeEsc2Unicode(s)));
                } else {
                    InputStream stream = file.getContents(false);
                    if (file.getFileExtension().equals("properties")) {
                        byte[] tmpBuf = new byte[102400];
                        int getSize = 0;
                        int totalGetSize = 0;
                        byte[] content = new byte[]{};
                        while ((getSize = stream.read(tmpBuf)) != -1) {
                            content = new byte[totalGetSize + getSize];
                            System.arraycopy(tmpBuf, 0, content, totalGetSize, getSize);
                            totalGetSize += getSize;
                        }
                        reader = new BufferedReader(new StringReader(EncodeChanger.unicodeEsc2Unicode(new String(content, file.getCharset()))));
                    } else {
                        reader = new BufferedReader(new InputStreamReader(stream, file.getCharset()));
                    }
                }
                try {
                    this.fLocator.locateMatches(this.fProgressMonitor, (Reader)reader, (IMatchCollector)new FileMatchCollector(this.fCollector, proxy));
                }
                catch (InvocationTargetException e1) {
                    throw (CoreException)e1.getCause();
                }
                Object var11_13 = null;
                this.updateProgressMonitor();
            }
            catch (IOException e) {
                String message = SearchMessages.getFormattedString((String)"TextSearchVisitor.error", (Object)file.getFullPath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.updateProgressMonitor();
            throw throwable;
        }
        return true;
    }
}

