/*
 *  ====================================================================
 *    Licensed to the Apache Software Foundation (ASF) under one or more
 *    contributor license agreements.  See the NOTICE file distributed with
 *    this work for additional information regarding copyright ownership.
 *    The ASF licenses this file to You under the Apache License, Version 2.0
 *    (the "License"); you may not use this file except in compliance with
 *    the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * ====================================================================
 */
package org.apache.poi.xslf.usermodel;

/**
 * Specified a list of text alignment types
 *
 * @author Yegor Kozlov
 */
public class TextAlign {
    /**
     * Align text to the left margin.
     */
	public static final TextAlign LEFT = new TextAlign(0);
    /**
     * Align text in the center.
     */
	public static final TextAlign CENTER = new TextAlign(1);

    /**
     * Align text to the right margin.
     */
	public static final TextAlign RIGHT = new TextAlign(2);

    /**
     * Align text so that it is justified across the whole line. It
     * is smart in the sense that it will not justify sentences
     * which are short
     */
	public static final TextAlign JUSTIFY = new TextAlign(3);
	public static final TextAlign JUSTIFY_LOW = new TextAlign(4);
	public static final TextAlign DIST = new TextAlign(5);
	public static final TextAlign THAI_DIST = new TextAlign(6);

	private int _ordinal;

	public TextAlign(int ordinal) {
		this._ordinal = ordinal;
	}

	public int ordinal() {
		return this._ordinal;
	}

	public static TextAlign[] values() {
		return new TextAlign[] { LEFT, CENTER, RIGHT, JUSTIFY, JUSTIFY_LOW,
				DIST, THAI_DIST };
	}
}
