/*
 *  ====================================================================
 *    Licensed to the Apache Software Foundation (ASF) under one or more
 *    contributor license agreements.  See the NOTICE file distributed with
 *    this work for additional information regarding copyright ownership.
 *    The ASF licenses this file to You under the Apache License, Version 2.0
 *    (the "License"); you may not use this file except in compliance with
 *    the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * ====================================================================
 */
package org.apache.poi.xslf.usermodel;

/**
 * @author Yegor Kozlov
 */
public class Placeholder {
	public static final Placeholder TITLE = new Placeholder(0);
	public static final Placeholder BODY = new Placeholder(1);
	public static final Placeholder CENTERED_TITLE = new Placeholder(2);
	public static final Placeholder SUBTITLE = new Placeholder(3);
	public static final Placeholder DATETIME = new Placeholder(4);
	public static final Placeholder SLIDE_NUMBER = new Placeholder(5);
	public static final Placeholder FOOTER = new Placeholder(6);
	public static final Placeholder HEADER = new Placeholder(7);
	public static final Placeholder CONTENT = new Placeholder(8);
	public static final Placeholder CHART = new Placeholder(9);
	public static final Placeholder TABLE = new Placeholder(10);
	public static final Placeholder CLIP_ART = new Placeholder(11);
	public static final Placeholder DGM = new Placeholder(12);
	public static final Placeholder MEDIA = new Placeholder(13);
	public static final Placeholder SLIDE_IMAGE = new Placeholder(14);
	public static final Placeholder PICTURE = new Placeholder(15);

	private int _ordinal;

	public Placeholder(int ordinal) {
		this._ordinal = ordinal;
	}

	public int ordinal() {
		return this._ordinal;
	}

	public static Placeholder[] values() {
		return new Placeholder[] { TITLE, BODY, CENTERED_TITLE, SUBTITLE,
				DATETIME, SLIDE_NUMBER, FOOTER, HEADER, CONTENT, CHART, TABLE,
				CLIP_ART, DGM, MEDIA, SLIDE_IMAGE, PICTURE };
	}
}
