/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.eventusermodel;

import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSSFSheetXMLHandler
extends DefaultHandler {
    private StylesTable stylesTable;
    private ReadOnlySharedStringsTable sharedStringsTable;
    private final SheetContentsHandler output;
    private boolean vIsOpen;
    private boolean fIsOpen;
    private boolean isIsOpen;
    private boolean hfIsOpen;
    private xssfDataType nextDataType;
    private short formatIndex;
    private String formatString;
    private final DataFormatter formatter;
    private String cellRef;
    private boolean formulasNotResults;
    private StringBuffer value = new StringBuffer();
    private StringBuffer formula = new StringBuffer();
    private StringBuffer headerFooter = new StringBuffer();

    public XSSFSheetXMLHandler(StylesTable styles, ReadOnlySharedStringsTable strings, SheetContentsHandler sheetContentsHandler, DataFormatter dataFormatter, boolean formulasNotResults) {
        this.stylesTable = styles;
        this.sharedStringsTable = strings;
        this.output = sheetContentsHandler;
        this.formulasNotResults = formulasNotResults;
        this.nextDataType = xssfDataType.NUMBER;
        this.formatter = dataFormatter;
    }

    public XSSFSheetXMLHandler(StylesTable styles, ReadOnlySharedStringsTable strings, SheetContentsHandler sheetContentsHandler, boolean formulasNotResults) {
        this(styles, strings, sheetContentsHandler, new DataFormatter(), formulasNotResults);
    }

    private boolean isTextTag(String name) {
        if ("v".equals(name)) {
            return true;
        }
        if ("inlineStr".equals(name)) {
            return true;
        }
        return "t".equals(name) && this.isIsOpen;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.isTextTag(name)) {
            this.vIsOpen = true;
            this.value.setLength(0);
        } else if ("is".equals(name)) {
            this.isIsOpen = true;
        } else if ("f".equals(name)) {
            String type;
            this.formula.setLength(0);
            if (this.nextDataType == xssfDataType.NUMBER) {
                this.nextDataType = xssfDataType.FORMULA;
            }
            if ((type = attributes.getValue("t")) != null && type.equals("shared")) {
                String ref = attributes.getValue("ref");
                String si = attributes.getValue("si");
                if (ref != null) {
                    this.fIsOpen = true;
                } else if (this.formulasNotResults) {
                    System.err.println("Warning - shared formulas not yet supported!");
                }
            } else {
                this.fIsOpen = true;
            }
        } else if ("oddHeader".equals(name) || "evenHeader".equals(name) || "firstHeader".equals(name) || "firstFooter".equals(name) || "oddFooter".equals(name) || "evenFooter".equals(name)) {
            this.hfIsOpen = true;
            this.headerFooter.setLength(0);
        } else if ("row".equals(name)) {
            int rowNum = Integer.parseInt(attributes.getValue("r")) - 1;
            this.output.startRow(rowNum);
        } else if ("c".equals(name)) {
            this.nextDataType = xssfDataType.NUMBER;
            this.formatIndex = (short)-1;
            this.formatString = null;
            this.cellRef = attributes.getValue("r");
            String cellType = attributes.getValue("t");
            String cellStyleStr = attributes.getValue("s");
            if ("b".equals(cellType)) {
                this.nextDataType = xssfDataType.BOOLEAN;
            } else if ("e".equals(cellType)) {
                this.nextDataType = xssfDataType.ERROR;
            } else if ("inlineStr".equals(cellType)) {
                this.nextDataType = xssfDataType.INLINE_STRING;
            } else if ("s".equals(cellType)) {
                this.nextDataType = xssfDataType.SST_STRING;
            } else if ("str".equals(cellType)) {
                this.nextDataType = xssfDataType.FORMULA;
            } else if (cellStyleStr != null) {
                int styleIndex = Integer.parseInt(cellStyleStr);
                XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
                this.formatIndex = style.getDataFormat();
                this.formatString = style.getDataFormatString();
                if (this.formatString == null) {
                    this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                }
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        String thisStr = null;
        if (this.isTextTag(name)) {
            this.vIsOpen = false;
            if (xssfDataType.BOOLEAN.equals(this.nextDataType)) {
                char first = this.value.charAt(0);
                thisStr = first == '0' ? "FALSE" : "TRUE";
            } else if (xssfDataType.ERROR.equals(this.nextDataType)) {
                thisStr = "ERROR:" + this.value.toString();
            } else if (xssfDataType.FORMULA.equals(this.nextDataType)) {
                if (this.formulasNotResults) {
                    thisStr = this.formula.toString();
                } else {
                    String fv = this.value.toString();
                    if (this.formatString != null) {
                        try {
                            double d = Double.parseDouble(fv);
                            thisStr = this.formatter.formatRawCellContents(d, (int)this.formatIndex, this.formatString);
                        }
                        catch (NumberFormatException e) {
                            thisStr = fv;
                        }
                    } else {
                        thisStr = fv;
                    }
                }
            } else if (xssfDataType.INLINE_STRING.equals(this.nextDataType)) {
                XSSFRichTextString rtsi = new XSSFRichTextString(this.value.toString());
                thisStr = rtsi.toString();
            } else if (xssfDataType.SST_STRING.equals(this.nextDataType)) {
                String sstIndex = this.value.toString();
                try {
                    int idx = Integer.parseInt(sstIndex);
                    XSSFRichTextString rtss = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                    thisStr = rtss.toString();
                }
                catch (NumberFormatException ex) {
                    System.err.println("Failed to parse SST index '" + sstIndex + "': " + ex.toString());
                }
            } else if (xssfDataType.NUMBER.equals(this.nextDataType)) {
                String n = this.value.toString();
                thisStr = this.formatString != null ? this.formatter.formatRawCellContents(Double.parseDouble(n), (int)this.formatIndex, this.formatString) : n;
            } else {
                thisStr = "(TODO: Unexpected type: " + this.nextDataType + ")";
            }
            this.output.cell(this.cellRef, thisStr);
        } else if ("f".equals(name)) {
            this.fIsOpen = false;
        } else if ("is".equals(name)) {
            this.isIsOpen = false;
        } else if ("row".equals(name)) {
            this.output.endRow();
        } else if ("oddHeader".equals(name) || "evenHeader".equals(name) || "firstHeader".equals(name)) {
            this.hfIsOpen = false;
            this.output.headerFooter(this.headerFooter.toString(), true, name);
        } else if ("oddFooter".equals(name) || "evenFooter".equals(name) || "firstFooter".equals(name)) {
            this.hfIsOpen = false;
            this.output.headerFooter(this.headerFooter.toString(), false, name);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(ch, start, length);
        }
        if (this.fIsOpen) {
            this.formula.append(ch, start, length);
        }
        if (this.hfIsOpen) {
            this.headerFooter.append(ch, start, length);
        }
    }

    public static interface SheetContentsHandler {
        public void startRow(int var1);

        public void endRow();

        public void cell(String var1, String var2);

        public void headerFooter(String var1, boolean var2, String var3);
    }

    public static final class xssfDataType {
        public static final xssfDataType BOOLEAN = new xssfDataType();
        public static final xssfDataType ERROR = new xssfDataType();
        public static final xssfDataType FORMULA = new xssfDataType();
        public static final xssfDataType INLINE_STRING = new xssfDataType();
        public static final xssfDataType SST_STRING = new xssfDataType();
        public static final xssfDataType NUMBER = new xssfDataType();
    }
}

