package org.phosphoresce.dbbrowser.resource.image;

import java.awt.Image;
import java.awt.Toolkit;

/**
 * C[W\[XێNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserImages {

	/** C[W\[XpX */
	public static final String IMAGE_RESOURCE_PATH = "/org/phosphoresce/dbbrowser/resource/image/";

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowserImages() {
	}

	// Static Method

	/**
	 * w肳ꂽC[W\[X擾܂B<br>
	 * @param image C[Wt@C
	 * @return C[WIuWFNg
	 */
	private static final Image getResourceImage(String image) {
		return Toolkit.getDefaultToolkit().getImage(DatabaseBrowserImages.class.getResource(IMAGE_RESOURCE_PATH + image));
	}

	// Common Image Resource

	/** Xy[T[ */
	public static final Image IMAGE_SPACER_48 = getResourceImage("common/spacer_48.png");

	/** Xy[T[ */
	public static final Image IMAGE_SPACER_32 = getResourceImage("common/spacer_32.png");

	/** Xy[T[ */
	public static final Image IMAGE_SPACER_24 = getResourceImage("common/spacer_24.png");

	/** Xy[T[ */
	public static final Image IMAGE_SPACER_20 = getResourceImage("common/spacer_20.png");

	/** Xy[T[ */
	public static final Image IMAGE_SPACER_16 = getResourceImage("common/spacer_16.png");

	// Application Image Resource

	/** AvP[VAoEgC[W */
	public static final Image IMAGE_APP_ABOUT_IMAGE = getResourceImage("application/app_about_image.png");

	/** AvP[VS */
	public static final Image IMAGE_APP_LOGO_36 = getResourceImage("application/app_logo_36.png");

	/** AvP[VS */
	public static final Image IMAGE_APP_LOGO_24 = getResourceImage("application/app_logo_24.png");

	/** AvP[VACR */
	public static final Image IMAGE_APP_ICON_256 = getResourceImage("application/app_icon_256.png");

	/** AvP[VACR */
	public static final Image IMAGE_APP_ICON_128 = getResourceImage("application/app_icon_128.png");

	/** AvP[VACR */
	public static final Image IMAGE_APP_ICON_64 = getResourceImage("application/app_icon_64.png");

	/** AvP[VACR */
	public static final Image IMAGE_APP_ICON_48 = getResourceImage("application/app_icon_48.png");

	/** AvP[VACR */
	public static final Image IMAGE_APP_ICON_32 = getResourceImage("application/app_icon_32.png");

	/** AvP[VACR */
	public static final Image IMAGE_APP_ICON_20 = getResourceImage("application/app_icon_20.png");

	/** AvP[VACR */
	public static final Image IMAGE_APP_ICON_16 = getResourceImage("application/app_icon_16.png");

	// Dialog Image Resource

	/** _CAOACR */
	public static final Image IMAGE_DIALOG_ICON_INFO = getResourceImage("dialog/dialog_icon_info.png");

	/** _CAOACR */
	public static final Image IMAGE_DIALOG_ICON_ERROR = getResourceImage("dialog/dialog_icon_error.png");

	/** _CAOACR */
	public static final Image IMAGE_DIALOG_ICON_QUESTION = getResourceImage("dialog/dialog_icon_question.png");

	/** _CAOACR */
	public static final Image IMAGE_DIALOG_ICON_WARN = getResourceImage("dialog/dialog_icon_warn.png");

	// Icon Image Resource

	/** ACR(NCAgPC) */
	public static final Image IMAGE_ICON_CLIENTPC_48 = getResourceImage("icon/icon_clientpc_48.png");

	/** ACR(NCAgPC) */
	public static final Image IMAGE_ICON_CLIENTPC_20 = getResourceImage("icon/icon_clientpc_20.png");

	/** ACR(f[^x[X) */
	public static final Image IMAGE_ICON_DATABASE_48 = getResourceImage("icon/icon_database_48.png");

	/** ACR(f[^x[X) */
	public static final Image IMAGE_ICON_DATABASE_20 = getResourceImage("icon/icon_database_20.png");

	/** ACR(NG) */
	public static final Image IMAGE_ICON_QUERY_48 = getResourceImage("icon/icon_query_48.png");

	/** ACR(NG) */
	public static final Image IMAGE_ICON_QUERY_20 = getResourceImage("icon/icon_query_20.png");

	/** ACR(f[^\[X) */
	public static final Image IMAGE_ICON_DATASOURCE_48 = getResourceImage("icon/icon_datasource_48.png");

	/** ACR(f[^\[X) */
	public static final Image IMAGE_ICON_DATASOURCE_32 = getResourceImage("icon/icon_datasource_32.png");

	/** ACR(f[^\[X) */
	public static final Image IMAGE_ICON_DATASOURCE_24 = getResourceImage("icon/icon_datasource_24.png");

	/** ACR(f[^\[X) */
	public static final Image IMAGE_ICON_DATASOURCE_16 = getResourceImage("icon/icon_datasource_16.png");

	/** ACR(J^O) */
	public static final Image IMAGE_ICON_CATALOG_48 = getResourceImage("icon/icon_catalog_48.png");

	/** ACR(J^O) */
	public static final Image IMAGE_ICON_CATALOG_32 = getResourceImage("icon/icon_catalog_32.png");

	/** ACR(J^O) */
	public static final Image IMAGE_ICON_CATALOG_24 = getResourceImage("icon/icon_catalog_24.png");

	/** ACR(J^O) */
	public static final Image IMAGE_ICON_CATALOG_16 = getResourceImage("icon/icon_catalog_16.png");

	/** ACR(XL[}) */
	public static final Image IMAGE_ICON_SCHEMA_48 = getResourceImage("icon/icon_schema_48.png");

	/** ACR(XL[}) */
	public static final Image IMAGE_ICON_SCHEMA_32 = getResourceImage("icon/icon_schema_32.png");

	/** ACR(XL[}) */
	public static final Image IMAGE_ICON_SCHEMA_24 = getResourceImage("icon/icon_schema_24.png");

	/** ACR(XL[}) */
	public static final Image IMAGE_ICON_SCHEMA_16 = getResourceImage("icon/icon_schema_16.png");

	/** ACR(e[u) */
	public static final Image IMAGE_ICON_TABLE_48 = getResourceImage("icon/icon_table_48.png");

	/** ACR(e[u) */
	public static final Image IMAGE_ICON_TABLE_32 = getResourceImage("icon/icon_table_32.png");

	/** ACR(e[u) */
	public static final Image IMAGE_ICON_TABLE_24 = getResourceImage("icon/icon_table_24.png");

	/** ACR(e[u) */
	public static final Image IMAGE_ICON_TABLE_16 = getResourceImage("icon/icon_table_16.png");

	// Button Image Resource

	/** {^ACR(R~bg) */
	public static final Image IMAGE_BUTTON_ICON_COMMIT_24 = getResourceImage("button/button_icon_commit_24.png");

	/** {^ACR(s) */
	public static final Image IMAGE_BUTTON_ICON_EXECUTE_24 = getResourceImage("button/button_icon_execute_24.png");

	/** {^ACR(s}) */
	public static final Image IMAGE_BUTTON_ICON_INSERTROW_24 = getResourceImage("button/button_icon_insertrow_24.png");

	/** {^ACR(s폜) */
	public static final Image IMAGE_BUTTON_ICON_DELETEROW_24 = getResourceImage("button/button_icon_deleterow_24.png");

	/** {^ACR([obN) */
	public static final Image IMAGE_BUTTON_ICON_ROLLBACK_24 = getResourceImage("button/button_icon_rollback_24.png");

	/** {^ACR(Z[u) */
	public static final Image IMAGE_BUTTON_ICON_SAVE_24 = getResourceImage("button/button_icon_save_24.png");
}
