package org.phosphoresce.dbbrowser.gui.window.main;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EFrame;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.DatabaseBrowserConstants;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.FrameStatusBarPanel;
import org.phosphoresce.dbbrowser.gui.logging.LoggingPane;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

/**
 * DatabaseBrowserAvP[Vt[NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/16	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserFrame extends EFrame implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static DatabaseBrowserFrame instance = null;

	/** CReipl */
	private EPanel mainContainerPanel = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowserFrame() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static DatabaseBrowserFrame instance() {
		if (instance == null) {
			instance = new DatabaseBrowserFrame();
		}
		return instance;
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setSize(new Dimension(900, 700));
		this.setContentPane(getMainContainerPanel());
		this.setIconImage(DatabaseBrowserImages.IMAGE_APP_ICON_32);
		this.setJMenuBar(DatabaseBrowserMenuBar.instance());
		this.setTitle(DatabaseBrowserConstants.APPLICATION_TITLE);
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		DatabaseBrowserTabbedPane.instance().refresh();
	}

	/**
	 * CReipl擾܂B<br>
	 * @return CReipl
	 */
	private EPanel getMainContainerPanel() {
		if (mainContainerPanel == null) {
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.gridx = 0;
			gridBagConstraints2.gridy = 1;
			gridBagConstraints2.weightx = 1.0;
			gridBagConstraints2.weighty = 0.0;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.gridx = 0;
			gridBagConstraints.gridy = 0;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.weighty = 1.0;
			mainContainerPanel = new EPanel();
			mainContainerPanel.setLayout(new GridBagLayout());
			mainContainerPanel.add(DatabaseBrowserPane.instance(), gridBagConstraints);
			mainContainerPanel.add(FrameStatusBarPanel.instance(), gridBagConstraints2);
		}
		return mainContainerPanel;
	}
}
