package org.phosphoresce.dbbrowser.gui.panel.dbinformation;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

/**
 * f[^x[Xpl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class DatabaseInformationPanel extends BrowserScrollableFramePanel {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** VOgZtCX^X */
	private static DatabaseInformationPanel instance = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseInformationPanel() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static DatabaseInformationPanel instance() {
		if (instance == null) {
			instance = new DatabaseInformationPanel();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		DatabaseInformationFieldSet.instance().refresh();
		JdbcConnectionInformationFieldSet.instance().refresh();
		DatabaseDetailFieldSet.instance().refresh();
		DatabaseSpecificationFieldSet.instance().refresh();
		DatabaseQuerySpecificationFieldSet.instance().refresh();
	}

	/**
	 * t[wb_^Cg擾܂B<br>
	 * @return t[wb_^Cg
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#getHeaderTitle()
	 */
	public String getHeaderTitle() {
		return "Database Information";
	}

	/**
	 * t[wb_ڍ׃bZ[W擾܂B<br>
	 * @return t[wb_ڍ׃bZ[W
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#getHeaderDescription()
	 */
	public String getHeaderDescription() {
		return "Connecting Database Server Informations.";
	}

	/**
	 * t[wb_ACR擾܂B<br>
	 * @return t[wb_ACR
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#getHeaderIcon()
	 */
	public Icon getHeaderIcon() {
		return new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_DATABASE_48);
	}

	/**
	 * t[yCRecpl𐶐܂B<br>
	 * @return t[yCRecpl
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#createContentPanel()
	 */
	protected EPanel createContentPanel() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 1.0D;
		gridBagConstraints1.weighty = 0.0D;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 4;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0D;
		gridBagConstraints2.weighty = 0.0D;
		gridBagConstraints2.gridx = 0;
		gridBagConstraints2.gridy = 3;
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.weightx = 1.0D;
		gridBagConstraints3.weighty = 0.0D;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 2;
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
		gridBagConstraints4.fill = GridBagConstraints.BOTH;
		gridBagConstraints4.weightx = 1.0D;
		gridBagConstraints4.weighty = 0.0D;
		gridBagConstraints4.gridx = 0;
		gridBagConstraints4.gridy = 1;
		GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
		gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
		gridBagConstraints5.fill = GridBagConstraints.BOTH;
		gridBagConstraints5.weightx = 1.0D;
		gridBagConstraints5.weighty = 0.0D;
		gridBagConstraints5.gridy = 0;
		gridBagConstraints5.gridx = 0;
		EPanel panel = new EPanel();
		panel.setLayout(new GridBagLayout());
		panel.add(DatabaseInformationFieldSet.instance(), gridBagConstraints5);
		panel.add(JdbcConnectionInformationFieldSet.instance(), gridBagConstraints4);
		panel.add(DatabaseDetailFieldSet.instance(), gridBagConstraints3);
		panel.add(DatabaseQuerySpecificationFieldSet.instance(), gridBagConstraints2);
		panel.add(DatabaseSpecificationFieldSet.instance(), gridBagConstraints1);
		return panel;
	}
}
