package org.phosphoresce.dbbrowser.gui.common.component;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;

import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.container.DatabaseCatalog;
import org.phosphoresce.commons.database.container.DatabaseContainer;
import org.phosphoresce.commons.database.container.DatabaseSchema;
import org.phosphoresce.commons.database.container.DatabaseTable;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.ETree;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * J^O/XL[}/e[uXgplNX<br>
 * <br>
 * NX͋ʂ̃NXƂĐ݂ꂽNXłB<br>
 * AAgpɂăXi[̓쓙͈قȂׁAVOgCX^X͒񋟂܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/18	Kitagawa		VK쐬
 *-->
 */
public final class CatalogSchemaTableListPanel extends EPanel implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** e[uc[ */
	private ETree tableTree = null;

	/** e[uc[XN[yC */
	private EScrollPane tableTreeScrollPane = null;

	/**
	 * RXgN^<br>
	 */
	public CatalogSchemaTableListPanel() {
		super();
		initialize();
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.fill = GridBagConstraints.BOTH;
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.weighty = 1.0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(180, 320));
		this.add(getTableTreeScrollPane(), gridBagConstraints);
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		// DatabaseContainerCX^X
		DatabaseContainer container = DatabaseContainer.createDatabaseContainer(DatabaseBrowserSession.instance().getCommonDatabaseSession());

		// Rootm[h
		DefaultMutableTreeNode containerNode = new DefaultMutableTreeNode(container);

		// J^O
		for (Iterator catalogIterator = container.getCatalogListIterator(); catalogIterator.hasNext();) {
			DatabaseCatalog catalog = (DatabaseCatalog) catalogIterator.next();
			DefaultMutableTreeNode catalogNode = new DefaultMutableTreeNode(catalog);
			containerNode.add(catalogNode);
			for (Iterator tableIterator = catalog.getTableListIterator(); tableIterator.hasNext();) {
				DatabaseTable table = (DatabaseTable) tableIterator.next();
				DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table);
				catalogNode.add(tableNode);
				// XL[}
				for (Iterator schemaIterator = catalog.getSchemaListIterator(); schemaIterator.hasNext();) {
					DatabaseSchema schema = (DatabaseSchema) schemaIterator.next();
					DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(schema);
					catalogNode.add(schemaNode);
					// e[u
					for (Iterator tableIterator2 = schema.getTableListIterator(); tableIterator2.hasNext();) {
						DatabaseTable table2 = (DatabaseTable) tableIterator.next();
						DefaultMutableTreeNode tableNode2 = new DefaultMutableTreeNode(table);
						schemaNode.add(tableNode2);
					}
				}
			}
		}
		// XL[}
		for (Iterator schemaIterator = container.getSchemaListIterator(); schemaIterator.hasNext();) {
			DatabaseSchema schema = (DatabaseSchema) schemaIterator.next();
			DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(schema);
			containerNode.add(schemaNode);
			for (Iterator tableIterator = schema.getTableListIterator(); tableIterator.hasNext();) {
				DatabaseTable table = (DatabaseTable) tableIterator.next();
				DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table);
				schemaNode.add(tableNode);
			}
		}
		// e[u
		for (Iterator tableIterator = container.getTableListIterator(); tableIterator.hasNext();) {
			DatabaseTable table = (DatabaseTable) tableIterator.next();
			DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table);
			containerNode.add(tableNode);
		}

		// c[fݒ
		DefaultTreeModel treeModel = new DefaultTreeModel(containerNode);
		getTableTree().setModel(treeModel);
	}

	/**
	 * e[uc[擾܂B<br>
	 * @return e[uc[
	 */
	public ETree getTableTree() {
		if (tableTree == null) {
			tableTree = new ETree();
			tableTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("no data")));
			tableTree.setCellRenderer(new CatalogSchemaTableListCellRenderer());
			tableTree.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
		}
		return tableTree;
	}

	/**
	 * e[uc[XN[yC擾܂B<br>
	 * @return e[uc[XN[yC
	 */
	public EScrollPane getTableTreeScrollPane() {
		if (tableTreeScrollPane == null) {
			tableTreeScrollPane = new EScrollPane();
			tableTreeScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
			tableTreeScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
			tableTreeScrollPane.setViewportView(getTableTree());
			tableTreeScrollPane.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
		}
		return tableTreeScrollPane;
	}
}
