package org.phosphoresce.dbbrowser.gui.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;

import javax.swing.BorderFactory;
import javax.swing.Icon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;

/**
 * t[wb_pl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public final class FrameHeaderPanel extends EPanel {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** wb_C[Wx */
	private ELabel headerImage = null;

	/** wb_^Cg */
	private ELabel headerTitile = null;

	/** wb_^CgVhE */
	private ELabel headerTitileShadow = null;

	/** wb_bZ[Wڍ */
	private ELabel headerDescription = null;

	/**
	 * RXgN^<br>
	 */
	public FrameHeaderPanel() {
		super();
		initialize();
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setLayout(null);
		this.setBackground(Color.white);
		this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
		this.setSize(new Dimension(400, 58));
		this.setPreferredSize(new Dimension(400, 58));
		this.setMinimumSize(new Dimension(1, 58));
		this.setMaximumSize(new Dimension(32767, 58));
		this.add(getHeaderImage(), null);
		this.add(getHeaderTitile(), null);
		this.add(getHeaderTitileShadow(), null);
		this.add(getHeaderDescription(), null);
	}

	/**
	 * wb_C[Wx擾܂B<br>
	 * @return wb_C[Wx
	 */
	private ELabel getHeaderImage() {
		if (headerImage == null) {
			headerImage = new ELabel();
			headerImage.setBounds(new Rectangle(5, 5, 48, 48));
		}
		return headerImage;
	}

	/**
	 * wb_^CgVhE擾܂B<br>
	 * @return wb_^CgVhE
	 */
	private ELabel getHeaderTitile() {
		if (headerTitile == null) {
			headerTitile = new ELabel();
			headerTitile.setText("");
			headerTitile.setBounds(new Rectangle(60, 8, 60, 22));
		}
		return headerTitile;
	}

	/**
	 * wb_^CgVhE擾܂B<br>
	 * @return wb_^CgVhE
	 */
	private ELabel getHeaderTitileShadow() {
		if (headerTitileShadow == null) {
			headerTitileShadow = new ELabel();
			headerTitileShadow.setText("");
			headerTitileShadow.setBounds(new Rectangle(61, 8, 60, 22));
		}
		return headerTitileShadow;
	}

	/**
	 * wb_bZ[Wڍׂ擾܂B
	 * @return wb_bZ[Wڍ
	 */
	private ELabel getHeaderDescription() {
		if (headerDescription == null) {
			headerDescription = new ELabel();
			headerDescription.setText("");
			headerDescription.setBounds(new Rectangle(60, 28, 60, 22));
		}
		return headerDescription;
	}

	/**
	 * R|[lg̓K؂ȃTCY̐ݒ^C~OŃwb_bZ[WR|[lgTCYύX܂B<br>
	 * @param preferredSize DimensionIuWFNg
	 * @see javax.swing.JComponent#setPreferredSize(java.awt.Dimension)
	 */
	public void setPreferredSize(Dimension preferredSize) {
		super.setPreferredSize(preferredSize);
		Rectangle titleBounds = getHeaderTitile().getBounds();
		Rectangle titleShadowBounds = getHeaderTitileShadow().getBounds();
		Rectangle descriptionBounds = getHeaderDescription().getBounds();
		titleBounds.width = getPreferredSize().width - 50;
		titleShadowBounds.width = getPreferredSize().width - 50;
		descriptionBounds.width = getPreferredSize().width - 50;
		getHeaderTitile().setBounds(titleBounds);
		getHeaderTitileShadow().setBounds(titleShadowBounds);
		getHeaderDescription().setBounds(descriptionBounds);
	}

	/**
	 * R|[lgTCY̐ݒ^C~OŃwb_bZ[WR|[lgTCYύX܂B<br>
	 * @param dimension DimensionIuWFNg
	 * @see java.awt.Component#setSize(java.awt.Dimension)
	 */
	public void setSize(Dimension dimension) {
		super.setSize(dimension);
		Rectangle titleBounds = getHeaderTitile().getBounds();
		Rectangle titleShadowBounds = getHeaderTitileShadow().getBounds();
		Rectangle descriptionBounds = getHeaderDescription().getBounds();
		titleBounds.width = getSize().width - 50;
		titleShadowBounds.width = getSize().width - 50;
		descriptionBounds.width = getSize().width - 50;
		getHeaderTitile().setBounds(titleBounds);
		getHeaderTitileShadow().setBounds(titleShadowBounds);
		getHeaderDescription().setBounds(descriptionBounds);
	}

	/**
	 * wb_ACRC[Wݒ肵܂B<br>
	 * @param icon wb_ACRC[W
	 */
	public void setHedaerIcon(Icon icon) {
		getHeaderImage().setIcon(icon);
	}

	/**
	 * wb_ACRC[W擾܂B<br>
	 * @return wb_ACRC[W
	 */
	public Icon getHeaderIcon() {
		return getHeaderImage().getIcon();
	}

	/**
	 * wb_bZ[WeLXgݒ肵܂B<br>
	 * @param message bZ[W
	 */
	public void setText(String message) {
		if (message == null) {
			getHeaderTitile().setText("");
			getHeaderTitileShadow().setText("");
		} else {
			getHeaderTitile().setText(message);
			getHeaderTitileShadow().setText(message);
		}
	}

	/**
	 * wb_bZ[WeLXg擾܂B<br>
	 * @return wb_bZ[WeLXg
	 */
	public String getText() {
		return getHeaderTitile().getText();
	}

	/**
	 * wb_bZ[Wڍ׃eLXgݒ肵܂B<br>
	 * @param message bZ[Wڍ
	 */
	public void setDescription(String message) {
		if (message == null) {
			getHeaderDescription().setText("");
		} else {
			getHeaderDescription().setText(message);
		}
	}

	/**
	 * wb_bZ[Wڍ׃eLXg擾܂B<br>
	 * @return wb_bZ[Wڍ׃eLXg
	 */
	public String getDescription() {
		return getHeaderDescription().getText();
	}
}
