/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.container;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.phosphoresce.commons.database.container.DatabaseCatalogHolder;
import org.phosphoresce.commons.database.container.DatabaseSchema;
import org.phosphoresce.commons.database.container.DatabaseSchemaHolder;
import org.phosphoresce.commons.database.container.DatabaseTable;
import org.phosphoresce.commons.database.container.DatabaseTableHolder;

public final class DatabaseCatalog
implements Serializable,
DatabaseSchemaHolder,
DatabaseTableHolder {
    private DatabaseCatalogHolder catalogHolder = null;
    private String name = null;
    private List schemaList = null;
    private List tableList = null;

    protected DatabaseCatalog(String name) {
        this.name = name;
        this.schemaList = new LinkedList();
        this.tableList = new LinkedList();
    }

    private DatabaseCatalog() {
        this(null);
    }

    public String getName() {
        return this.name;
    }

    public Iterator getSchemaListIterator() {
        return this.schemaList.iterator();
    }

    public int getSchemaListCount() {
        return this.schemaList.size();
    }

    public DatabaseSchema getSchema(String name) {
        String key = name == null ? "" : name;
        Iterator iterator = this.schemaList.iterator();
        while (iterator.hasNext()) {
            DatabaseSchema schema = (DatabaseSchema)iterator.next();
            if (!key.equals(schema.getName())) continue;
            return schema;
        }
        return null;
    }

    public Iterator getTableListIterator() {
        return this.tableList.iterator();
    }

    public int getTableListCount() {
        return this.tableList.size();
    }

    public DatabaseTable getTable(String name) {
        String key = name == null ? "" : name;
        Iterator iterator = this.tableList.iterator();
        while (iterator.hasNext()) {
            DatabaseTable table = (DatabaseTable)iterator.next();
            if (!key.equals(table.getName())) continue;
            return table;
        }
        return null;
    }

    public DatabaseCatalogHolder getCatalogHolder() {
        return this.catalogHolder;
    }

    protected void setCatalogHolder(DatabaseCatalogHolder catalogHolder) {
        this.catalogHolder = catalogHolder;
    }

    protected void addSchema(DatabaseSchema schema) {
        this.schemaList.add(schema);
    }

    protected void addTable(DatabaseTable table) {
        this.tableList.add(table);
    }
}

