/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.common.component;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.phosphoresce.commons.database.container.DatabaseCatalog;
import org.phosphoresce.commons.database.container.DatabaseContainer;
import org.phosphoresce.commons.database.container.DatabaseSchema;
import org.phosphoresce.commons.database.container.DatabaseTable;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

public class CatalogSchemaTableListCellRenderer
extends DefaultTreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (selected) {
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            this.setBackground(UIManager.getColor("Tree.selectionBackground"));
        } else {
            this.setForeground(UIManager.getColor("Tree.textForeground"));
            this.setBackground(UIManager.getColor("Tree.textBackground"));
        }
        if (value == null || !(value instanceof DefaultMutableTreeNode)) {
            this.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_SPACER_16));
            this.setForeground(Color.RED);
            this.setText("failed to render tree node");
        }
        Object object = ((DefaultMutableTreeNode)value).getUserObject();
        this.setForeground(Color.BLACK);
        if (object instanceof DatabaseContainer) {
            DatabaseContainer container = (DatabaseContainer)object;
            this.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_DATASOURCE_16));
            this.setText("Database");
        } else if (object instanceof DatabaseCatalog) {
            DatabaseCatalog catalog = (DatabaseCatalog)object;
            this.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_CATALOG_16));
            this.setText(catalog.getName());
        } else if (object instanceof DatabaseSchema) {
            DatabaseSchema schema = (DatabaseSchema)object;
            this.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_SCHEMA_16));
            this.setText(schema.getName());
        } else if (object instanceof DatabaseTable) {
            DatabaseTable table = (DatabaseTable)object;
            this.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_TABLE_16));
            this.setText(table.getName());
        } else {
            this.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_SPACER_16));
            this.setText(object.toString());
        }
        return this;
    }
}

