/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;

public final class FrameHeaderPanel
extends EPanel {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ELabel headerImage = null;
    private ELabel headerTitile = null;
    private ELabel headerTitileShadow = null;
    private ELabel headerDescription = null;

    public FrameHeaderPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        this.setSize(new Dimension(400, 58));
        this.setPreferredSize(new Dimension(400, 58));
        this.setMinimumSize(new Dimension(1, 58));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 58));
        this.add((Component)this.getHeaderImage(), null);
        this.add((Component)this.getHeaderTitile(), null);
        this.add((Component)this.getHeaderTitileShadow(), null);
        this.add((Component)this.getHeaderDescription(), null);
    }

    private ELabel getHeaderImage() {
        if (this.headerImage == null) {
            this.headerImage = new ELabel();
            this.headerImage.setBounds(new Rectangle(5, 5, 48, 48));
        }
        return this.headerImage;
    }

    private ELabel getHeaderTitile() {
        if (this.headerTitile == null) {
            this.headerTitile = new ELabel();
            this.headerTitile.setText("");
            this.headerTitile.setBounds(new Rectangle(60, 8, 60, 22));
        }
        return this.headerTitile;
    }

    private ELabel getHeaderTitileShadow() {
        if (this.headerTitileShadow == null) {
            this.headerTitileShadow = new ELabel();
            this.headerTitileShadow.setText("");
            this.headerTitileShadow.setBounds(new Rectangle(61, 8, 60, 22));
        }
        return this.headerTitileShadow;
    }

    private ELabel getHeaderDescription() {
        if (this.headerDescription == null) {
            this.headerDescription = new ELabel();
            this.headerDescription.setText("");
            this.headerDescription.setBounds(new Rectangle(60, 28, 60, 22));
        }
        return this.headerDescription;
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        Rectangle titleBounds = this.getHeaderTitile().getBounds();
        Rectangle titleShadowBounds = this.getHeaderTitileShadow().getBounds();
        Rectangle descriptionBounds = this.getHeaderDescription().getBounds();
        titleBounds.width = this.getPreferredSize().width - 50;
        titleShadowBounds.width = this.getPreferredSize().width - 50;
        descriptionBounds.width = this.getPreferredSize().width - 50;
        this.getHeaderTitile().setBounds(titleBounds);
        this.getHeaderTitileShadow().setBounds(titleShadowBounds);
        this.getHeaderDescription().setBounds(descriptionBounds);
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        Rectangle titleBounds = this.getHeaderTitile().getBounds();
        Rectangle titleShadowBounds = this.getHeaderTitileShadow().getBounds();
        Rectangle descriptionBounds = this.getHeaderDescription().getBounds();
        titleBounds.width = this.getSize().width - 50;
        titleShadowBounds.width = this.getSize().width - 50;
        descriptionBounds.width = this.getSize().width - 50;
        this.getHeaderTitile().setBounds(titleBounds);
        this.getHeaderTitileShadow().setBounds(titleShadowBounds);
        this.getHeaderDescription().setBounds(descriptionBounds);
    }

    public void setHedaerIcon(Icon icon) {
        this.getHeaderImage().setIcon(icon);
    }

    public Icon getHeaderIcon() {
        return this.getHeaderImage().getIcon();
    }

    public void setText(String message) {
        if (message == null) {
            this.getHeaderTitile().setText("");
            this.getHeaderTitileShadow().setText("");
        } else {
            this.getHeaderTitile().setText(message);
            this.getHeaderTitileShadow().setText(message);
        }
    }

    public String getText() {
        return this.getHeaderTitile().getText();
    }

    public void setDescription(String message) {
        if (message == null) {
            this.getHeaderDescription().setText("");
        } else {
            this.getHeaderDescription().setText(message);
        }
    }

    public String getDescription() {
        return this.getHeaderDescription().getText();
    }
}

