package org.phosphoresce.commons.wpoi.util;

import java.io.Serializable;

import org.apache.poi.hssf.usermodel.HSSFPrintSetup;

/**
 * POIV[gݒNXB<br>
 * HSSFSheet񋟂V[gɑ΂ݒ݂̂ێB<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2006/01/25
 * 
 *<!--
 * XV       XV          XVe
 * 2006/01/25	Kitagawa		VK쐬
 *-->
 */
public final class PoiPrintConfig implements Serializable {

	/** pTCY(A4) */
	public static final short PAPER_A4 = HSSFPrintSetup.A4_PAPERSIZE;

	/** pTCY(A5) */
	public static final short PAPER_A5 = HSSFPrintSetup.A5_PAPERSIZE;

	/**
	 * <br>
	 * true : u / false : cu(fBtHg)
	 */
	private boolean landscape = false;

	/**
	 * gk@<br>
	 * true : wcy[W / false : gk{w(fBtHg)<br>
	 **/
	private boolean autobreaks = false;

	/**
	 * {<br>
	 * fBtHgl : 100
	 */
	private short scale = 100;

	/**
	 * y[W()@<br>
	 * true : 񂹈 / false : 񂹈(fBtHg)
	 */
	private boolean horizontallyCenter = false;

	/**
	 * y[W()@<br>
	 * true : 񂹈 / false : 񂹈(fBtHg)
	 */
	private boolean verticallyCenter = false;

	/**
	 * y[W}[W㕔<br>
	 * fBtHgl : 2.0<br>
	 */
	private double marginOfTop = 2.0;

	/**
	 * y[W}[W<br>
	 * fBtHgl : 2.0<br>
	 */
	private double marginOfBottom = 2.0;

	/**
	 * y[W}[W<br>
	 * fBtHgl : 2.0<br>
	 */
	private double marginOfLeft = 2.0;

	/**
	 * y[W}[WE<br>
	 * fBtHgl : 2.0<br>
	 */
	private double marginOfRight = 2.0;

	/**
	 * wb_[<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * fBtHgl : ""<br>
	 */
	private String headerLeftString = "";

	/**
	 * wb_[<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * fBtHgl : ""<br>
	 */
	private String headerCenterString = "";

	/**
	 * wb_[E<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * fBtHgl : ""<br>
	 */
	private String headerRightString = "";

	/**
	 * tb^[<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * fBtHgl : ""<br>
	 */
	private String footerLeftString = "";

	/**
	 * tb^[<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * fBtHgl : ""<br>
	 */
	private String footerCenterString = "";

	/**
	 * tb^[E<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * fBtHgl : ""<br>
	 */
	private String footerRightString = "";

	/**
	 * wb_[}[W<br>
	 * fBtHgl : 1.0<br>
	 */
	private double marginOfHeader = 1.0;

	/**
	 * tb^[}[W<br>
	 * fBtHgl : 1.0<br>
	 */
	private double marginOfFooter = 1.0;

	/**
	 * wcy[Wł̏c̃y[W<br>
	 * fBtHgl : 1<br>
	 */
	private short fitPageVerticalCount = 1;

	/**
	 * wcy[Wł̉̃y[W<br>
	 * fBtHgl : 1<br>
	 */
	private short fitPageHorizontalCount = 1;

	/**
	 * <br>
	 * fBtHgl : 1<br>
	 */
	private short copies = 1;

	/**
	 * ȈՈݒ<br>
	 * true : ȈՈ / false : ʏ(fBtHg)
	 */
	private boolean draft = false;

	/**
	 * i(dpi)<br>
	 * fBtHgl : 600<br>
	 */
	private short dpi = 600;

	/**
	 * y[Wォ牺Ƃ<br>
	 * true : ォ牺 / false : E(fBtHg)
	 */
	private boolean printTopToDown = false;

	/**
	 * ݒ<br>]
	 * true :  / false : ʏ(fBtHg)
	 */
	private boolean monoPrint = false;

	/**
	 * Rgݒ<br>
	 * ʃC[Wǂ̈̂ݑΉ<br>
	 * true : Rg / false : Rg(fBtHg)
	 */
	private boolean printComment = false;

	/**
	 * 擪y[W<br>
	 * fBtHgl : 1(擪y[W)<br>
	 */
	private short startPage = 1;

	/**
	 * pTCY<br>
	 * fBtHgl : PAPER_A4<br>
	 */
	private short paperSize = PAPER_A4;

	/**
	 * 擾܂B<br>
	 * @return 
	 */
	public boolean isLandscape() {
		return landscape;
	}

	/**
	 * ݒ肵܂B<br>
	 * @param landscape 
	 */
	public void setLandscape(boolean landscape) {
		this.landscape = landscape;
	}

	/**
	 * gk@擾܂B<br>
	 * @return gk@
	 */
	public boolean isAutobreaks() {
		return autobreaks;
	}

	/**
	 * gk@ݒ肵܂B<br>
	 * @param autobreaks gk@
	 */
	public void setAutobreaks(boolean autobreaks) {
		this.autobreaks = autobreaks;
	}

	/**
	 * {擾܂B<br>
	 * @return {
	 */
	public short getScale() {
		return scale;
	}

	/**
	 * {ݒ肵܂B<br>
	 * @param scale {
	 */
	public void setScale(short scale) {
		this.scale = scale;
	}

	/**
	 * y[W()@擾܂B<br>
	 * @return y[W()@
	 */
	public boolean isHorizontallyCenter() {
		return horizontallyCenter;
	}

	/**
	 * y[W()@ݒ肵܂B<br>
	 * @param horizontallyCenter y[W()@
	 */
	public void setHorizontallyCenter(boolean horizontallyCenter) {
		this.horizontallyCenter = horizontallyCenter;
	}

	/**
	 * y[W()@擾܂B<br>
	 * @return y[W()@
	 */
	public boolean isVerticallyCenter() {
		return verticallyCenter;
	}

	/**
	 * y[W()@ݒ肵܂B<br>
	 * @param verticallyCenter y[W()@
	 */
	public void setVerticallyCenter(boolean verticallyCenter) {
		this.verticallyCenter = verticallyCenter;
	}

	/**
	 * y[W}[W擾܂B<br>
	 * @return y[W}[W
	 */
	public double getMarginOfBottom() {
		return marginOfBottom;
	}

	/**
	 * y[W}[Wݒ肵܂B<br>
	 * @param marginOfBottom y[W}[W
	 */
	public void setMarginOfBottom(double marginOfBottom) {
		this.marginOfBottom = marginOfBottom;
	}

	/**
	 * y[W}[W擾܂B<br>
	 * @return y[W}[W
	 */
	public double getMarginOfLeft() {
		return marginOfLeft;
	}

	/**
	 * y[W}[Wݒ肵܂B<br>
	 * @param marginOfLeft y[W}[W
	 */
	public void setMarginOfLeft(double marginOfLeft) {
		this.marginOfLeft = marginOfLeft;
	}

	/**
	 * y[W}[WE擾܂B<br>
	 * @return y[W}[WE
	 */
	public double getMarginOfRight() {
		return marginOfRight;
	}

	/**
	 * y[W}[WEݒ肵܂B<br>
	 * @param marginOfRight y[W}[WE
	 */
	public void setMarginOfRight(double marginOfRight) {
		this.marginOfRight = marginOfRight;
	}

	/**
	 * y[W}[W㕔擾܂B<br>
	 * @return y[W}[W㕔
	 */
	public double getMarginOfTop() {
		return marginOfTop;
	}

	/**
	 * y[W}[W㕔ݒ肵܂B<br>
	 * @param marginOfTop y[W}[W㕔
	 */
	public void setMarginOfTop(double marginOfTop) {
		this.marginOfTop = marginOfTop;
	}

	/**
	 * tb^[擾܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @return tb^[
	 */
	public String getFooterCenterString() {
		return footerCenterString;
	}

	/**
	 * tb^[ݒ肵܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @param footerCenterString tb^[
	 */
	public void setFooterCenterString(String footerCenterString) {
		this.footerCenterString = footerCenterString;
	}

	/**
	 * tb^[擾܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @return tb^[
	 */
	public String getFooterLeftString() {
		return footerLeftString;
	}

	/**
	 * tb^[ݒ肵܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @param footerLeftString tb^[
	 */
	public void setFooterLeftString(String footerLeftString) {
		this.footerLeftString = footerLeftString;
	}

	/**
	 * tb^[E擾܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @return tb^[E
	 */
	public String getFooterRightString() {
		return footerRightString;
	}

	/**
	 * tb^[Eݒ肵܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @param footerRightString tb^[E
	 */
	public void setFooterRightString(String footerRightString) {
		this.footerRightString = footerRightString;
	}

	/**
	 * wb_[擾܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @return wb_[
	 */
	public String getHeaderCenterString() {
		return headerCenterString;
	}

	/**
	 * wb_[ݒ肵܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @param headerCenterString wb_[
	 */
	public void setHeaderCenterString(String headerCenterString) {
		this.headerCenterString = headerCenterString;
	}

	/**
	 * wb_[擾܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @return wb_[
	 */
	public String getHeaderLeftString() {
		return headerLeftString;
	}

	/**
	 * wb_[ݒ肵܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @param headerLeftString wb_[
	 */
	public void setHeaderLeftString(String headerLeftString) {
		this.headerLeftString = headerLeftString;
	}

	/**
	 * wb_[E擾܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @return wb_[E
	 */
	public String getHeaderRightString() {
		return headerRightString;
	}

	/**
	 * wb_[Eݒ肵܂B<br>
	 * PoiPrintStringBuilderŒ񋟂鑕ɑΉB<br>
	 * @param headerRightString wb_[E
	 */
	public void setHeaderRightString(String headerRightString) {
		this.headerRightString = headerRightString;
	}

	/**
	 * tb^[}[W擾܂B<br>
	 * @return marginOfFooter
	 */
	public double getMarginOfFooter() {
		return marginOfFooter;
	}

	/**
	 * tb^[}[Wݒ肵܂B<br>
	 * @param marginOfFooter tb^[}[W
	 */
	public void setMarginOfFooter(double marginOfFooter) {
		this.marginOfFooter = marginOfFooter;
	}

	/**
	 * wb_[}[W擾܂B<br>
	 * @return wb_[}[W
	 */
	public double getMarginOfHeader() {
		return marginOfHeader;
	}

	/**
	 * wb_[}[Wݒ肵܂B<br>
	 * @param marginOfHeader wb_[}[W
	 */
	public void setMarginOfHeader(double marginOfHeader) {
		this.marginOfHeader = marginOfHeader;
	}

	/**
	 * wcy[Wł̉̃y[W擾܂B<br>
	 * @return wcy[Wł̉̃y[W
	 */
	public short getFitPageHorizontalCount() {
		return fitPageHorizontalCount;
	}

	/**
	 * wcy[Wł̉̃y[Wݒ肵܂B<br>
	 * @param fitPageHorizontalCount wcy[Wł̉̃y[W
	 */
	public void setFitPageHorizontalCount(short fitPageHorizontalCount) {
		this.fitPageHorizontalCount = fitPageHorizontalCount;
	}

	/**
	 * wcy[Wł̏c̃y[W擾܂B<br>
	 * @return wcy[Wł̏c̃y[W
	 */
	public short getFitPageVerticalCount() {
		return fitPageVerticalCount;
	}

	/**
	 * wcy[Wł̏c̃y[Wݒ肵܂B<br>
	 * @param fitPageVerticalCount wcy[Wł̏c̃y[W
	 */
	public void setFitPageVerticalCount(short fitPageVerticalCount) {
		this.fitPageVerticalCount = fitPageVerticalCount;
	}

	/**
	 * 擾܂B<br>
	 * @return 
	 */
	public short getCopies() {
		return copies;
	}

	/**
	 * ݒ肵܂B<br>
	 * @param copies 
	 */
	public void setCopies(short copies) {
		this.copies = copies;
	}

	/**
	 * i(dpi)擾܂B<br>
	 * @return i(dpi)
	 */
	public short getDpi() {
		return dpi;
	}

	/**
	 * i(dpi)ݒ肵܂B<br>
	 * @param dpi i(dpi)
	 */
	public void setDpi(short dpi) {
		this.dpi = dpi;
	}

	/**
	 * ȈՈ擾܂B<br>
	 * @return ȈՈ
	 */
	public boolean isDraft() {
		return draft;
	}

	/**
	 * ȈՈݒ肵܂B<br>
	 * @param draft ȈՈ
	 */
	public void setDraft(boolean draft) {
		this.draft = draft;
	}

	/**
	 * 擾܂B<br>
	 * @return 
	 */
	public boolean isMonoPrint() {
		return monoPrint;
	}

	/**
	 * ݒ肵܂B<br>
	 * @param monoPrint 
	 */
	public void setMonoPrint(boolean monoPrint) {
		this.monoPrint = monoPrint;
	}

	/**
	 * pTCY擾܂B<br>
	 * @return pTCY
	 */
	public short getPaperSize() {
		return paperSize;
	}

	/**
	 * pTCYݒ肵܂B<br>
	 * @param paperSize pTCY
	 */
	public void setPaperSize(short paperSize) {
		this.paperSize = paperSize;
	}

	/**
	 * Rgݒ擾܂B<br>
	 * @return Rgݒ
	 */
	public boolean isPrintComment() {
		return printComment;
	}

	/**
	 * Rgݒݒ肵܂B<br>
	 * @param printComment Rgݒ
	 */
	public void setPrintComment(boolean printComment) {
		this.printComment = printComment;
	}

	/**
	 * (ォ牺)ݒ擾܂B<br>
	 * @return (ォ牺)ݒ
	 */
	public boolean isPrintTopToDown() {
		return printTopToDown;
	}

	/**
	 * (ォ牺)ݒݒ肵܂B<br>
	 * @param printTopToDown (ォ牺)ݒ
	 */
	public void setPrintTopToDown(boolean printTopToDown) {
		this.printTopToDown = printTopToDown;
	}

	/**
	 * 擪y[W擾܂B<br>
	 * @return 擪y[W
	 */
	public short getStartPage() {
		return startPage;
	}

	/**
	 * 擪y[Wݒ肵܂B<br>
	 * @param startPage 擪y[W
	 */
	public void setStartPage(short startPage) {
		this.startPage = startPage;
	}
}
