/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.wpoi.adapter;

import java.io.Serializable;
import org.phosphoresce.commons.wpoi.exception.PoiException;

public final class PoiRange
implements Serializable {
    private int rowFrom;
    private short colFrom;
    private int rowTo;
    private short colTo;

    public PoiRange() {
        this.rowFrom = 0;
        this.colFrom = 0;
        this.rowTo = 0;
        this.colTo = 0;
    }

    public PoiRange(PoiRange range) throws PoiException {
        this.rowFrom = range.rowFrom;
        this.colFrom = range.colFrom;
        this.rowTo = range.rowTo;
        this.colTo = range.colTo;
        this.validate();
    }

    public PoiRange(int rowFrom, short colFrom, int rowTo, short colTo) throws PoiException {
        this.rowFrom = rowFrom;
        this.colFrom = colFrom;
        this.rowTo = rowTo;
        this.colTo = colTo;
        this.validate();
    }

    private void validate() throws PoiException {
        int buffer;
        if (this.rowTo < this.rowFrom) {
            buffer = this.rowTo;
            this.rowTo = this.rowFrom;
            this.rowFrom = buffer;
        }
        if (this.colTo < this.colFrom) {
            buffer = this.colTo;
            this.colTo = this.colFrom;
            this.colFrom = (short)buffer;
        }
        if (this.rowFrom < 0 || this.rowTo < 0 || this.colFrom < 0 || this.colTo < 0) {
            throw new PoiException("\u7bc4\u56f2\u60c5\u5831\u304c\u8ca0\u6570\u3068\u306a\u3063\u3066\u3044\u307e\u3059[" + this.toString() + "]");
        }
    }

    public short getColFrom() {
        return this.colFrom;
    }

    public void setColFrom(short colFrom) throws PoiException {
        this.colFrom = colFrom;
        this.validate();
    }

    public short getColTo() {
        return this.colTo;
    }

    public void setColTo(short colTo) throws PoiException {
        this.colTo = colTo;
        this.validate();
    }

    public int getRowFrom() {
        return this.rowFrom;
    }

    public void setRowFrom(int rowFrom) throws PoiException {
        this.rowFrom = rowFrom;
        this.validate();
    }

    public int getRowTo() {
        return this.rowTo;
    }

    public void setRowTo(int rowTo) throws PoiException {
        this.rowTo = rowTo;
        this.validate();
    }

    public int getHeight() {
        return this.rowTo - this.rowFrom + 1;
    }

    public short getWidth() {
        return (short)(this.colTo - this.colFrom + 1);
    }

    public void shift(int row, short col) throws PoiException {
        this.colFrom = (short)(this.colFrom + col);
        this.colTo = (short)(this.colTo + col);
        this.rowFrom += row;
        this.rowTo += row;
        this.validate();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("rowFrom=");
        buffer.append(this.getRowFrom());
        buffer.append(",");
        buffer.append("colFrom=");
        buffer.append(Double.toString(this.getColFrom()));
        buffer.append(",");
        buffer.append("rowTo=");
        buffer.append(this.getRowTo());
        buffer.append(",");
        buffer.append("colTo=");
        buffer.append(Short.toString(this.getColTo()));
        buffer.append("}");
        return buffer.toString();
    }
}

