/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.contentnotifier.util;

import java.util.LinkedList;
import java.util.StringTokenizer;

public final class StringUtil {
    private StringUtil() {
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static String[] getTokenArray(String value, String delim) {
        LinkedList<String> list = new LinkedList<String>();
        if (!StringUtil.isEmpty(value) && !StringUtil.isEmpty(delim)) {
            String buffer = "";
            StringTokenizer tokenizer = new StringTokenizer(value, delim, true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (delim.equals(token)) {
                    list.add(buffer);
                    buffer = "";
                } else {
                    buffer = token;
                }
                if (tokenizer.hasMoreTokens() || StringUtil.isEmpty(buffer)) continue;
                list.add(buffer);
                buffer = "";
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String replace(String source, String before, String after) {
        if (StringUtil.isEmpty(source) || source.indexOf(before) == -1) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        int index = source.indexOf(before);
        buffer.append(source.substring(0, index) + after);
        if (index + before.length() < source.length()) {
            String rest = source.substring(index + before.length(), source.length());
            buffer.append(StringUtil.replace(rest, before, after));
        }
        return buffer.toString();
    }

    public static String binder(String source, String key, String param) {
        if (param == null || param.length() == 0 || source == null || source.length() == 0) {
            return source;
        }
        String render = source;
        String replaceWord = "${" + key + "}";
        while (render.indexOf(replaceWord) >= 0) {
            render = StringUtil.replace(render, replaceWord, param);
        }
        return render;
    }
}

