/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.miya.pglauncher.utils;

import java.net.URL;
import java.util.Properties;
import jp.gr.java_conf.miya.pglauncher.PGLauncherPlugin;
import jp.gr.java_conf.miya.pglauncher.common.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.internal.misc.ExternalProgramImageDescriptor;

public class ImageUtils {
    private static ImageRegistry registry_ = new ImageRegistry();
    private static Properties imagePaths_ = new Properties();

    static {
        imagePaths_.setProperty("pglauncher", "/icons/pglauncher.gif");
        imagePaths_.setProperty("group", "/icons/group.gif");
        imagePaths_.setProperty("folder", "/icons/folder.gif");
        imagePaths_.setProperty("exe", "/icons/exe.gif");
        imagePaths_.setProperty("unknown", "/icons/unknown.gif");
        imagePaths_.setProperty("config", "/icons/config.gif");
        imagePaths_.setProperty("error", "/icons/error.gif");
        imagePaths_.setProperty("run", "/icons/run.gif");
    }

    private ImageUtils() {
    }

    public static Image getImageFromIcon(String name) {
        Image img = registry_.get(name);
        if (img == null) {
            ImageUtils._createImageFromIcon(name);
            img = registry_.get(name);
        }
        return img;
    }

    public static org.eclipse.jface.resource.ImageDescriptor getImageDescriptorFromIcon(String name) {
        org.eclipse.jface.resource.ImageDescriptor imgDesc = registry_.getDescriptor(name);
        if (imgDesc == null) {
            ImageUtils._createImageFromIcon(name);
            imgDesc = registry_.getDescriptor(name);
        }
        return imgDesc;
    }

    public static Image getImageFromProgram(String path) {
        String extension = path.substring(path.lastIndexOf(".") + 1);
        Image img = null;
        img = extension.equalsIgnoreCase("exe") ? registry_.get(path) : registry_.get(extension);
        if (img != null) {
            return img;
        }
        ImageUtils._createImageFromProgram(path);
        if (extension.equalsIgnoreCase("exe")) {
            return registry_.get(path);
        }
        return registry_.get(extension);
    }

    public static org.eclipse.jface.resource.ImageDescriptor getImageDescriptorFromProgram(String path) {
        String extension = path.substring(path.lastIndexOf(".") + 1);
        org.eclipse.jface.resource.ImageDescriptor imgDesc = null;
        imgDesc = extension.equalsIgnoreCase("exe") ? registry_.getDescriptor(path) : registry_.getDescriptor(extension);
        if (imgDesc != null) {
            return imgDesc;
        }
        ImageUtils._createImageFromProgram(path);
        if (extension.equalsIgnoreCase("exe")) {
            return registry_.getDescriptor(path);
        }
        return registry_.getDescriptor(extension);
    }

    private static void _createImageFromIcon(String name) {
        PGLauncherPlugin plugin = PGLauncherPlugin.getDefault();
        URL url = plugin.getBundle().getEntry(imagePaths_.getProperty(name));
        if (url != null) {
            registry_.put(name, org.eclipse.jface.resource.ImageDescriptor.createFromURL((URL)url));
        }
    }

    private static void _createImageFromProgram(String path) {
        String extension = path.substring(path.lastIndexOf(".") + 1);
        if (extension.equalsIgnoreCase("exe")) {
            TCHAR lpszFile = new TCHAR(0, path, true);
            int[] phiconSmall = new int[1];
            int[] phiconLarge = null;
            OS.ExtractIconEx((TCHAR)lpszFile, (int)0, (int[])phiconLarge, (int[])phiconSmall, (int)1);
            if (phiconSmall[0] == 0) {
                return;
            }
            Image img = Image.win32_new(null, (int)1, (int)phiconSmall[0]);
            if (img != null) {
                ImageData imgData = img.getImageData();
                img.dispose();
                registry_.put(path, (org.eclipse.jface.resource.ImageDescriptor)new ImageDescriptor(imgData));
            }
        } else {
            Program prg = Program.findProgram((String)extension);
            if (prg != null) {
                registry_.put(extension, (org.eclipse.jface.resource.ImageDescriptor)new ExternalProgramImageDescriptor(prg));
            }
        }
    }
}

