/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.actions.AbstractAction;
import jp.gr.java_conf.miya.pglauncher.actions.ActionEventProvider;
import jp.gr.java_conf.miya.pglauncher.dialogs.GroupDialog;
import jp.gr.java_conf.miya.pglauncher.dialogs.ProgramDialog;
import jp.gr.java_conf.miya.pglauncher.utils.TreeUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UpdateAction
extends AbstractAction {
    private TreeViewer viewer_;

    public UpdateAction(TreeViewer viewer, ActionEventProvider provider) {
        super("\u4fee\u6b63", null, provider);
        this.viewer_ = viewer;
    }

    public void run() {
        Element el = TreeUtils.getSelectedElement(this.viewer_);
        String type = el.getNodeName();
        if (type.equals("group")) {
            this.updateGroup(el);
        } else if (type.equals("program")) {
            this.updateProgram(el, 0);
        } else if (type.equals("folder")) {
            this.updateProgram(el, 1);
        }
        this.viewer_.refresh();
        this.viewer_.setSelection((ISelection)new StructuredSelection((Object)el), true);
    }

    public void updateGroup(Node node) {
        NamedNodeMap map = node.getAttributes();
        Node attr = map.getNamedItem("name");
        String name = attr.getNodeValue();
        GroupDialog dialog = new GroupDialog(this.viewer_.getControl().getShell(), name);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            attr.setNodeValue(dialog.getGroupName());
        }
    }

    public void updateProgram(Node node, int focus) {
        NamedNodeMap map = node.getAttributes();
        Node attrName = map.getNamedItem("name");
        String name = attrName.getNodeValue();
        Node attrPath = map.getNamedItem("path");
        String path = attrPath.getNodeValue();
        Node attrArg = map.getNamedItem("arg");
        String arg = null;
        if (attrArg != null) {
            arg = attrArg.getNodeValue();
        }
        ProgramDialog dialog = new ProgramDialog(this.viewer_.getControl().getShell(), name, path, arg, focus);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Element el = null;
            if (dialog.isFolder()) {
                el = ((Document)this.viewer_.getInput()).createElement("folder");
                el.setAttribute("name", dialog.getProgramName());
                el.setAttribute("path", dialog.getPath());
            } else if (dialog.isProgram()) {
                el = ((Document)this.viewer_.getInput()).createElement("program");
                el.setAttribute("name", dialog.getProgramName());
                el.setAttribute("path", dialog.getPath());
                el.setAttribute("arg", dialog.getArg());
            }
            node.getParentNode().replaceChild(el, node);
        }
    }

    public void doubleClick(Event event) {
        this.run();
    }

    public void rightClick(Event event) {
        Element el = TreeUtils.getSelectedElement(this.viewer_);
        String type = el.getNodeName();
        if (type.equals("pglauncher")) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void keyDown(Event event) {
        switch (event.keyCode) {
            case 0x100000B: {
                this.run();
            }
        }
    }
}

