/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.Address;
import pencilbox.kakuro.Board;
import pencilbox.kakuro.HintTbl;

public class DigitPatternHint {
    private Board board;
    private int[][] horizPattern;
    private int[][] vertPattern;

    int getPattern(Address p) {
        int pat = this.horizPattern[p.r()][p.c()] & this.vertPattern[p.r()][p.c()];
        if ((pat & 1) == 1) {
            return 1;
        }
        return pat;
    }

    void setupHint(Board board) {
        this.board = board;
        this.horizPattern = new int[board.rows()][board.cols()];
        this.vertPattern = new int[board.rows()][board.cols()];
    }

    void updatePattern(Address p) {
        this.updatePattern(p, 1);
        this.updatePattern(p, 0);
    }

    void updatePattern(Address p0, int dir) {
        int i;
        int pattern = 0;
        Address headPosition = this.board.getWordHead(p0, dir);
        int wordSum = this.board.getWordSum(p0, dir);
        int wordSize = this.board.getWordSize(p0, dir);
        int currentSum = 0;
        int currentSize = 0;
        int usedDigit = 0;
        Address p = headPosition;
        if (wordSum == 0) {
            pattern = 1023;
        } else if (wordSize > 9) {
            pattern = 0;
        } else {
            i = 0;
            while (i < wordSize) {
                int n = this.board.getNumber(p = Address.nextCell(p, dir | 2));
                if (n > 0) {
                    ++currentSize;
                    currentSum += n;
                    usedDigit |= 1 << n;
                }
                ++i;
            }
            pattern = currentSize == wordSize ? 0 : HintTbl.getRemainingDigit(wordSum - currentSum, wordSize - currentSize, usedDigit);
        }
        i = 0;
        while (i < wordSize) {
            if (dir == 1) {
                this.horizPattern[p0.r()][headPosition.c() + 1 + i] = pattern;
            } else if (dir == 0) {
                this.vertPattern[headPosition.r() + 1 + i][p0.c()] = pattern;
            }
            ++i;
        }
    }

    void initHint() {
        Address p;
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            this.vertPattern[p.r()][p.c()] = 1023;
            this.horizPattern[p.r()][p.c()] = 1023;
            ++n2;
        }
        addressArray = this.board.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (this.board.isWall(p)) {
                int d = 0;
                while (d < 2) {
                    Address p1 = Address.nextCell(p, d | 2);
                    if (!this.board.isWall(p1)) {
                        // empty if block
                    }
                    if (this.board.getSum(p, d) > 0) {
                        this.updatePattern(p1, d);
                    }
                    ++d;
                }
            }
            ++n2;
        }
    }
}

