/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.masyu;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BorderEditStep;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.SideAddress;
import pencilbox.masyu.Link;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int UP = 0;
    static final int DN = 2;
    static final int LT = 1;
    static final int RT = 3;
    static final int UNKNOWN = 0;
    static final int LINE = 1;
    static final int NOLINE = -1;
    static final int OUTER = -9;
    static final int BLANK = 0;
    static final int WHITE_PEARL = 1;
    static final int BLACK_PEARL = 2;
    static final int GRAY_PEARL = 3;
    private int[][] number;
    private int[][][] state;
    private List<Link> linkList;
    private Link[][][] link;
    private Link initializingLink;

    @Override
    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        this.state = new int[2][][];
        this.state[0] = new int[this.rows()][this.cols() - 1];
        this.state[1] = new int[this.rows() - 1][this.cols()];
        this.linkList = new LinkedList<Link>();
        this.link = new Link[2][][];
        this.link[0] = new Link[this.rows()][this.cols() - 1];
        this.link[1] = new Link[this.rows() - 1][this.cols()];
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt3(this.state, 0);
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        SideAddress[] sideAddressArray = this.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            if (this.getState(p) == -1) {
                this.changeState(p, 0);
            }
            ++n2;
        }
    }

    int[][][] getState() {
        return this.state;
    }

    int[][] getNumber() {
        return this.number;
    }

    public void setNumber(int r, int c, int st) {
        this.number[r][c] = st;
    }

    public void setNumber(Address pos, int st) {
        this.setNumber(pos.r(), pos.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public boolean isNumber(Address pos) {
        int n = this.getNumber(pos);
        return n >= 1 && n <= 3;
    }

    public int getState(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.state[d][r][c];
        }
        return -9;
    }

    public int getState(SideAddress pos) {
        return this.getState(pos.d(), pos.r(), pos.c());
    }

    public void setState(int d, int r, int c, int st) {
        this.state[d][r][c] = st;
    }

    public void setState(SideAddress pos, int st) {
        this.setState(pos.d(), pos.r(), pos.c(), st);
    }

    public boolean isLineJ(Address p0, int direction) {
        SideAddress p = SideAddress.get(p0, direction);
        return this.isSideOn(p) && this.getState(p) == 1;
    }

    public Link getLink(SideAddress pos) {
        if (this.isSideOn(pos)) {
            return this.link[pos.d()][pos.r()][pos.c()];
        }
        return null;
    }

    public Link getLink(Address p) {
        int d = 0;
        while (d < 4) {
            Link link = this.getLink(SideAddress.get(p, d));
            if (link != null) {
                return link;
            }
            ++d;
        }
        return null;
    }

    public void setLink(SideAddress pos, Link l) {
        this.link[pos.d()][pos.r()][pos.c()] = l;
    }

    public void changeNumber(Address p, int n) {
        int prev = this.getNumber(p);
        if (prev == n) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(p, prev, n));
        }
        this.setNumber(p, n);
    }

    public void changeState(SideAddress p, int st) {
        int prev = this.getState(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new BorderEditStep(p, prev, st));
        }
        this.setState(p, st);
        if (prev == 1) {
            this.cutLink(p);
        }
        if (st == 1) {
            this.connectLink(p);
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeState(s.getPos(), s.getBefore());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeState(s.getPos(), s.getAfter());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getAfter());
        }
    }

    @Override
    public void initBoard() {
        this.initLinks();
    }

    void initLinks() {
        Link.resetId();
        this.linkList.clear();
        ArrayUtil.initArrayObject2(this.link[0], null);
        ArrayUtil.initArrayObject2(this.link[1], null);
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.initLink(p);
            ++n2;
        }
    }

    void initLink(Address p) {
        this.initializingLink = new Link();
        int d = 0;
        while (d < 4) {
            this.initLink1(SideAddress.get(p, d));
            ++d;
        }
        if (!this.initializingLink.isEmpty()) {
            this.linkList.add(this.initializingLink);
        }
    }

    private void initLink1(SideAddress p) {
        if (!this.isSideOn(p)) {
            return;
        }
        if (this.getState(p) != 1) {
            return;
        }
        if (this.getLink(p) != null) {
            return;
        }
        this.initializingLink.add(p);
        this.setLink(p, this.initializingLink);
        int d = 0;
        while (d < 6) {
            this.initLink1(SideAddress.nextBorder(p, d));
            ++d;
        }
    }

    void connectLink(SideAddress p) {
        Link link;
        Link newLink = new Link();
        int d = 0;
        while (d < 2) {
            link = this.getLink(SideAddress.nextCellFromBorder(p, d));
            if (link != null && link.size() > newLink.size()) {
                newLink = link;
            }
            ++d;
        }
        if (newLink.isEmpty()) {
            this.linkList.add(newLink);
        }
        d = 0;
        while (d < 2) {
            link = this.getLink(SideAddress.nextCellFromBorder(p, d));
            if (link != null && link != newLink) {
                for (SideAddress b : link) {
                    this.setLink(b, newLink);
                    newLink.add(b);
                }
                this.linkList.remove(link);
            }
            ++d;
        }
        newLink.add(p);
        this.setLink(p, newLink);
    }

    void cutLink(SideAddress p) {
        Link oldLink = this.getLink(p);
        Link longerLink = new Link();
        for (SideAddress b : oldLink) {
            this.setLink(b, null);
        }
        this.linkList.remove(oldLink);
        int d = 0;
        while (d < 2) {
            Address p1 = SideAddress.nextCellFromBorder(p, d);
            this.initLink(p1);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
            ++d;
        }
        longerLink.setId(oldLink.getId());
    }

    public int countLine(Address p) {
        int no = 0;
        int d = 0;
        while (d < 4) {
            SideAddress b = SideAddress.get(p, d);
            if (this.isSideOn(b) && this.getState(b) == 1) {
                ++no;
            }
            ++d;
        }
        return no;
    }

    int checkWhitePearl(Address p) {
        int l = this.countLine(p);
        if (l > 2) {
            return -1;
        }
        if (l < 2) {
            return 0;
        }
        if (this.isLineJ(p, 0) && this.isLineJ(p, 3)) {
            return -1;
        }
        if (this.isLineJ(p, 0) && this.isLineJ(p, 1)) {
            return -1;
        }
        if (this.isLineJ(p, 2) && this.isLineJ(p, 3)) {
            return -1;
        }
        if (this.isLineJ(p, 2) && this.isLineJ(p, 1)) {
            return -1;
        }
        if (this.isLineJ(p, 0) && this.isLineJ(p, 2)) {
            Address pu = Address.nextCell(p, 0);
            Address pd = Address.nextCell(p, 2);
            if (this.isLineJ(pu, 0) && this.isLineJ(pd, 2)) {
                return -1;
            }
            if (this.isLineJ(pu, 3)) {
                return 2;
            }
            if (this.isLineJ(pu, 1)) {
                return 2;
            }
            if (this.isLineJ(pd, 3)) {
                return 2;
            }
            if (this.isLineJ(pd, 1)) {
                return 2;
            }
            return 1;
        }
        if (this.isLineJ(p, 1) && this.isLineJ(p, 3)) {
            Address pl = Address.nextCell(p, 1);
            Address pr = Address.nextCell(p, 3);
            if (this.isLineJ(pl, 1) && this.isLineJ(pr, 3)) {
                return -1;
            }
            if (this.isLineJ(pl, 0)) {
                return 2;
            }
            if (this.isLineJ(pl, 2)) {
                return 2;
            }
            if (this.isLineJ(pr, 0)) {
                return 2;
            }
            if (this.isLineJ(pr, 2)) {
                return 2;
            }
            return 1;
        }
        return -9;
    }

    int checkBlackPearl(Address p) {
        int success = 0;
        int l = this.countLine(p);
        if (l > 2) {
            return -1;
        }
        if (l < 2) {
            return 0;
        }
        if (this.isLineJ(p, 0) && this.isLineJ(p, 2)) {
            return -1;
        }
        if (this.isLineJ(p, 3) && this.isLineJ(p, 1)) {
            return -1;
        }
        if (this.isLineJ(p, 0)) {
            Address pu = Address.nextCell(p, 0);
            if (this.isLineJ(pu, 1)) {
                return -1;
            }
            if (this.isLineJ(pu, 3)) {
                return -1;
            }
            success = this.isLineJ(pu, 0) ? (success |= 2) : (success |= 1);
        }
        if (this.isLineJ(p, 2)) {
            Address pd = Address.nextCell(p, 2);
            if (this.isLineJ(pd, 1)) {
                return -1;
            }
            if (this.isLineJ(pd, 3)) {
                return -1;
            }
            success = this.isLineJ(pd, 2) ? (success |= 2) : (success |= 1);
        }
        if (this.isLineJ(p, 1)) {
            Address pl = Address.nextCell(p, 1);
            if (this.isLineJ(pl, 0)) {
                return -1;
            }
            if (this.isLineJ(pl, 2)) {
                return -1;
            }
            success = this.isLineJ(pl, 1) ? (success |= 8) : (success |= 4);
        }
        if (this.isLineJ(p, 3)) {
            Address pr = Address.nextCell(p, 3);
            if (this.isLineJ(pr, 0)) {
                return -1;
            }
            if (this.isLineJ(pr, 2)) {
                return -1;
            }
            success = this.isLineJ(pr, 3) ? (success |= 8) : (success |= 4);
        }
        if (success == 10) {
            return 2;
        }
        if (success > 0) {
            return 1;
        }
        return -9;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        int n = 0;
        Address[] addressArray = this.cellAddrs();
        int n2 = addressArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Address p = addressArray[n3];
            int l = this.countLine(p);
            if (l > 2) {
                result |= 1;
            } else if (l == 1) {
                result |= 2;
            }
            int pearl = this.getNumber(p);
            if (pearl == 1) {
                n = this.checkWhitePearl(p);
                if (n == -1) {
                    result |= 4;
                } else if (n == 0) {
                    result |= 0x20;
                }
            }
            if (pearl == 2) {
                n = this.checkBlackPearl(p);
                if (n == -1) {
                    result |= 8;
                } else if (n == 0) {
                    result |= 0x40;
                }
            }
            ++n3;
        }
        if (this.linkList.size() > 1) {
            result |= 0x10;
        } else if (this.linkList.size() == 0) {
            result |= 0x80;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("masyu.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("masyu.AnswerCheckMessage2"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("masyu.AnswerCheckMessage5"));
        }
        if ((result & 0x80) == 128) {
            message.append(Messages.getString("masyu.AnswerCheckMessage8"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("masyu.AnswerCheckMessage3"));
        } else if ((result & 0x20) == 32) {
            message.append(Messages.getString("masyu.AnswerCheckMessage6"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("masyu.AnswerCheckMessage4"));
        } else if ((result & 0x40) == 64) {
            message.append(Messages.getString("masyu.AnswerCheckMessage7"));
        }
        return message.toString();
    }
}

