/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shakashaka;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.shakashaka.Board;

public class Panel
extends PanelBase {
    private Board board;

    public Panel() {
        this.setMarkStyle(3);
        this.setGridColor(Color.GRAY);
        this.setNumberColor(Color.WHITE);
        this.setPaintColor(new Color(153));
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawCells(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    private void drawCells(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int number = this.board.getNumber(p);
            g.setColor(this.getWallColor());
            if (Board.isNumber(number)) {
                this.paintCell(g, p);
                if (number >= 0 && number <= 4) {
                    g.setColor(this.getNumberColor());
                    if (this.isIndicateErrorMode() && this.board.countAdjacentTriangles(p) != number) {
                        g.setColor(this.getErrorColor());
                    }
                    this.placeNumber(g, p, number);
                }
            } else {
                int state;
                int cra;
                if (this.isIndicateErrorMode() && (cra = this.board.getArea(p).checkRectangleArea()) > 0) {
                    g.setColor(this.successColor);
                    this.paintCell(g, p);
                }
                if (Board.isTriangle(state = this.board.getState(p))) {
                    g.setColor(this.getPaintColor());
                    this.paintTriangle(g, p, state);
                } else if (state == -3) {
                    g.setColor(this.getCircleColor());
                    this.placeMark(g, p);
                }
            }
            ++n2;
        }
    }

    public void paintTriangle(Graphics2D g, Address p, int state) {
        int x0 = this.toX(p.c());
        int x1 = x0 + this.getCellSize();
        int y0 = this.toX(p.r());
        int y1 = y0 + this.getCellSize();
        if (state == 4) {
            g.fillPolygon(new int[]{x1, x0, x0}, new int[]{y0, y0, y1}, 3);
        } else if (state == 5) {
            g.fillPolygon(new int[]{x0, x0, x1}, new int[]{y0, y1, y1}, 3);
        } else if (state == 6) {
            g.fillPolygon(new int[]{x0, x1, x1}, new int[]{y1, y1, y0}, 3);
        } else if (state == 7) {
            g.fillPolygon(new int[]{x1, x1, x0}, new int[]{y1, y0, y0}, 3);
        }
    }
}

