/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelBase;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.Board;

public class Panel
extends PanelBase {
    private Board board;
    private Area draggingArea;
    private HintDot hintDot = new HintDot();

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setCursorMode(true);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.hintDot.setDot(this, 3, this.getCellSize());
    }

    Area getDraggingArea() {
        return this.draggingArea;
    }

    void setDraggingArea(Area draggingArea) {
        this.draggingArea = draggingArea;
    }

    @Override
    public void setDisplaySize(int cellSize) {
        super.setDisplaySize(cellSize);
        this.hintDot.setDotSize(cellSize);
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.paintCells(g);
        this.drawBeams(g);
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
    }

    private void drawBeams(Graphics2D g) {
        if (this.isHighlightSelectionMode()) {
            Address[] addressArray = this.board.cellAddrs();
            int n = addressArray.length;
            int n2 = 0;
            while (n2 < n) {
                Address p = addressArray[n2];
                int n3 = this.board.getNumberOrState(p);
                if (n3 > 0 && n3 == this.getSelectedNumber()) {
                    int d = 0;
                    while (d < 4) {
                        Address p1 = p;
                        int k = 0;
                        while (k < n3) {
                            if (this.board.isOn(p1 = Address.nextCell(p1, d))) {
                                g.setColor(this.beamColor);
                                this.placeCenterLine(g, p1, d & 1);
                            }
                            ++k;
                        }
                        ++d;
                    }
                }
                ++n2;
            }
        }
    }

    private void paintCells(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.board.getArea(p) == null) {
                g.setColor(this.noAreaColor);
                this.paintCell(g, p);
            } else if (this.board.getArea(p) == this.draggingArea) {
                g.setColor(this.draggingAreaColor);
                this.paintCell(g, p);
            }
            if (this.isHighlightSelectionMode() && this.getSelectedNumber() > 0 && this.board.getNumberOrState(p) == this.getSelectedNumber()) {
                g.setColor(this.highlightColor);
                this.paintCell(g, p);
            }
            ++n2;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int n3 = this.board.getNumber(p);
            int s = this.board.getState(p);
            if (n3 > 0) {
                g.setColor(this.getNumberColor());
                this.placeNumber(g, p, n3);
            } else if (n3 == -2) {
                if (this.isDotHintMode()) {
                    this.placeHintDot(g, p);
                }
                g.setColor(this.getNumberColor());
                this.placeBoldCircle(g, p);
            } else if (s > 0) {
                g.setColor(this.getInputColor());
                if (this.isIndicateErrorMode() && this.board.isError(p)) {
                    g.setColor(this.getErrorColor());
                }
                this.placeNumber(g, p, s);
            } else if (this.isDotHintMode()) {
                this.placeHintDot(g, p);
            }
            ++n2;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        g.setColor(this.getAreaBorderColor());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int[] nArray = Direction.DN_RT;
            int n3 = Direction.DN_RT.length;
            int n4 = 0;
            while (n4 < n3) {
                int d = nArray[n4];
                Address p1 = p.nextCell(d);
                SideAddress b = SideAddress.get(p, d);
                if (this.board.isSideOn(b) && this.board.getArea(p) != this.board.getArea(p1)) {
                    this.placeSideLine(g, b);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void placeHintDot(Graphics2D g, Address p) {
        int pat = this.board.getPattern(p);
        if (pat == 0) {
            this.hintDot.placeHintCross(g, p);
        } else {
            this.hintDot.placeHintDot(g, p, pat);
        }
    }
}

