/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.io;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Property;
import pencilbox.common.core.Size;
import pencilbox.common.io.DataFormatException;
import pencilbox.common.io.XmlConstants;

public abstract class XmlReaderBase
extends DefaultHandler
implements XmlConstants {
    private String puzzleType;
    protected String node;
    private String rowNode;
    private String boardNode;
    protected Attributes attributes;
    private BoardBase board;
    private Property property;
    private Problem problem;
    private Size size;
    private int rowNo;
    private int colNo;
    private DataFormatException exception;

    protected BoardBase makeBoard() {
        return null;
    }

    public void setPuzzleType(String s) {
        this.puzzleType = s;
    }

    protected Problem readProblem(File file) throws ParserConfigurationException, SAXException, IOException, DataFormatException {
        this.exception = null;
        SAXParser sax = SAXParserFactory.newInstance().newSAXParser();
        this.problem = new Problem();
        this.property = this.problem.getProperty();
        sax.parse(file, (DefaultHandler)this);
        if (this.exception != null) {
            throw this.exception;
        }
        return this.problem;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        block59: {
            try {
                this.node = qName.intern();
                this.attributes = attributes;
                if (this.node == "puzzle") {
                    this.onPuzzle();
                } else if (this.node == "size") {
                    this.onSize();
                } else if (this.node == "board") {
                    this.onBoard();
                } else if (this.node == "brow") {
                    this.onBrow();
                } else if (this.node == "answer") {
                    this.onAnswer();
                } else if (this.node == "arow") {
                    this.onArow();
                } else if (this.node == "z") {
                    this.onN(0);
                } else if (this.node == "n1") {
                    this.onN(1);
                } else if (this.node == "n2") {
                    this.onN(2);
                } else if (this.node == "n3") {
                    this.onN(3);
                } else if (this.node == "n4") {
                    this.onN(4);
                } else if (this.node == "n5") {
                    this.onN(5);
                } else if (this.node == "n6") {
                    this.onN(6);
                } else if (this.node == "n7") {
                    this.onN(7);
                } else if (this.node == "n8") {
                    this.onN(8);
                } else if (this.node == "n9") {
                    this.onN(9);
                } else if (this.node == "n") {
                    this.onN();
                } else if (this.node == "c") {
                    this.onChar();
                } else if (this.node == "h") {
                    this.onType();
                } else if (this.node == "hv") {
                    this.onType();
                } else if (this.node == "s") {
                    this.onType();
                } else if (this.node == "u") {
                    this.onType();
                } else if (this.node == "v") {
                    this.onType();
                } else if (this.node == "w") {
                    this.onType();
                } else if (this.node == "number") {
                    this.onNumber();
                } else if (this.node != "property") {
                    if (this.node == "author") {
                        this.property.setAuthor(attributes.getValue("value"));
                    } else if (this.node == "source") {
                        this.property.setSource(attributes.getValue("value"));
                    } else if (this.node == "difficulty") {
                        this.property.setDifficulty(attributes.getValue("value"));
                    } else {
                        this.start();
                    }
                }
            }
            catch (DataFormatException e) {
                if (this.exception != null) break block59;
                this.exception = e;
            }
        }
    }

    protected void start() {
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.endElementX(uri, localName, qName);
    }

    private void endElementX(String uri, String localName, String qName) {
        this.node = qName.intern();
        if (this.node == "brow") {
            this.onBrowEnd();
        } else if (this.node == "arow") {
            this.onArowEnd();
        } else if (this.node == "board") {
            this.onBoardEnd();
        } else if (this.node == "answer") {
            this.onAnswerEnd();
        }
    }

    protected void onPuzzle() throws DataFormatException {
        if (!this.puzzleType.equals(this.attributes.getValue("type"))) {
            throw new DataFormatException("wrong puzzle type");
        }
    }

    protected void onSize() throws DataFormatException {
        String rowAttr = this.attributes.getValue("row");
        String colAttr = this.attributes.getValue("col");
        if (rowAttr == null || colAttr == null) {
            throw new DataFormatException("size error");
        }
        int row = Integer.parseInt(rowAttr);
        int col = Integer.parseInt(colAttr);
        this.size = new Size(row, col);
        this.board = this.makeBoard();
        this.board.setSize(this.size);
        this.problem.setBoard(this.board);
    }

    protected void onBoard() {
        this.boardNode = this.node;
        this.rowNo = 0;
    }

    protected void onBoardEnd() {
    }

    protected void onAnswerEnd() {
    }

    protected void onAnswer() {
        this.rowNo = 0;
        this.colNo = 0;
    }

    protected void onBrow() {
        this.rowNode = this.node;
    }

    protected void onBrowEnd() {
        ++this.rowNo;
        this.colNo = 0;
    }

    protected void onArow() {
        this.rowNode = this.node;
    }

    protected void onArowEnd() {
        ++this.rowNo;
        this.colNo = 0;
    }

    protected void onN() {
        int v = 0;
        String vAttr = this.attributes.getValue("v");
        if (vAttr != null) {
            v = Integer.parseInt(vAttr);
        }
        this.onN(v);
    }

    protected void onN(int v) {
        int n = 1;
        String nAttr = this.attributes.getValue("n");
        if (nAttr != null) {
            n = Integer.parseInt(nAttr);
        }
        int i = 0;
        while (i < n) {
            if (this.rowNode == "brow") {
                this.setBN(this.rowNo, this.colNo, v);
            } else {
                this.setAN(this.rowNo, this.colNo, v);
            }
            ++this.colNo;
            ++i;
        }
    }

    protected void onNumber() {
        int r = Integer.parseInt(this.attributes.getValue("r")) - 1;
        int c = Integer.parseInt(this.attributes.getValue("c")) - 1;
        int n = Integer.parseInt(this.attributes.getValue("n"));
        if (this.boardNode == "board") {
            this.setBN(r, c, n);
        } else if (this.boardNode == "answer") {
            this.setAN(r, c, n);
        }
    }

    protected void onChar() {
        char c = '?';
        String vAttr = this.attributes.getValue("v");
        if (vAttr != null && vAttr.length() != 0) {
            c = vAttr.charAt(0);
        }
        int n = 1;
        String nAttr = this.attributes.getValue("n");
        if (nAttr != null) {
            n = Integer.parseInt(nAttr);
        }
        int i = 0;
        while (i < n) {
            if (this.rowNode == "brow") {
                this.setBC(this.rowNo, this.colNo, c);
            } else {
                this.setAC(this.rowNo, this.colNo, c);
            }
            ++this.colNo;
            ++i;
        }
    }

    protected void setBN(int r, int c, int v) {
    }

    protected void setAN(int r, int c, int v) {
    }

    protected void setBC(int r, int c, char v) {
    }

    protected void setAC(int r, int c, char v) {
    }

    protected void setBSpace(int r, int c) {
    }

    protected void setASpace(int r, int c) {
    }

    protected void onType() {
        int n = 1;
        String nAttr = this.attributes.getValue("n");
        if (nAttr != null) {
            n = Integer.parseInt(nAttr);
        }
        int i = 0;
        while (i < n) {
            if (this.rowNode == "brow") {
                this.setBType(this.rowNo, this.colNo, this.node);
            } else {
                this.setAType(this.rowNo, this.colNo, this.node);
            }
            ++this.colNo;
            ++i;
        }
    }

    protected void setBType(int r, int c, String type) {
    }

    protected void setAType(int r, int c, String type) {
    }
}

