/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.io;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Property;
import pencilbox.common.core.Size;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;

public abstract class PclReaderBase {
    private PencilType pencilType;
    private BoardBase board;
    private Property property;
    private Size size;
    private Problem problem;

    public Problem readProblem(File file) throws ParserConfigurationException, SAXException, IOException, PencilBoxClassException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(file);
        this.makeProblem(doc);
        return this.problem;
    }

    public Problem makeProblem(Document doc) throws PencilBoxClassException {
        this.problem = new Problem();
        this.property = this.problem.getProperty();
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Element childElement = (Element)child;
                String tagName = childElement.getTagName();
                Text textNode = (Text)childElement.getFirstChild();
                String text = textNode.getData().trim();
                if (tagName.equals("type")) {
                    this.pencilType = PencilType.getPencilType(text);
                    this.board = (BoardBase)ClassUtil.createInstance(this.pencilType, "Board");
                } else if (tagName.equals("size")) {
                    this.readSize(text);
                } else if (tagName.equals("question")) {
                    this.readQuestion(text);
                } else if (tagName.equals("answer")) {
                    this.readAnswer(text);
                } else if (tagName.equals("author")) {
                    this.property.setAuthor(text);
                } else if (tagName.equals("difficulty")) {
                    this.property.setDifficulty(text);
                } else if (tagName.equals("source")) {
                    this.property.setSource(text);
                }
            }
            ++i;
        }
        this.problem.setBoard(this.board);
        this.problem.setProperty(this.property);
        return this.problem;
    }

    protected void readSize(String text) {
        StringTokenizer t = new StringTokenizer(text);
        int col = Integer.parseInt(t.nextToken());
        int row = Integer.parseInt(t.nextToken());
        this.size = new Size(row, col);
        this.board.setSize(this.size);
    }

    protected void readQuestion(String text) {
        System.out.println("readQuestion() method is not defined.");
    }

    protected void readAnswer(String text) {
        System.out.println("readAnswer() method is not defined.");
    }

    protected BoardBase getBoard() {
        return this.board;
    }
}

