/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.Size;

public class Address
implements Comparable<Address> {
    private static int MAX = -2;
    private static Address[][] ADDRESS;
    public static final Address NOWHERE;
    private final int r;
    private final int c;

    static {
        Address.createAddressInstances(11);
        NOWHERE = Address.address(-1, -1);
    }

    public static void createAddressInstances(int m) {
        if (m <= MAX) {
            return;
        }
        Address[][] newAddress = new Address[m + 2][m + 2];
        int r = -1;
        while (r <= m) {
            int c = -1;
            while (c <= m) {
                newAddress[r + 1][c + 1] = r + 1 <= MAX && c + 1 <= MAX ? ADDRESS[r + 1][c + 1] : new Address(r, c);
                ++c;
            }
            ++r;
        }
        MAX = m;
        ADDRESS = newAddress;
    }

    public static void createAddressInstances(Size size) {
        int m = size.getCols() > size.getCols() ? size.getRows() : size.getCols();
        Address.createAddressInstances(m);
    }

    protected Address() {
        this(0, 0);
    }

    protected Address(Address pos) {
        this.r = pos.r;
        this.c = pos.c;
    }

    protected Address(int r, int c) {
        this.r = r;
        this.c = c;
    }

    public static Address address() {
        return new Address();
    }

    public static Address address(Address pos) {
        return new Address(pos);
    }

    public static Address address(int r, int c) {
        if (r >= -1 && r <= MAX && c >= -1 && c <= MAX) {
            return ADDRESS[r + 1][c + 1];
        }
        return new Address(r, c);
    }

    public static Address nowhere() {
        return NOWHERE;
    }

    public int r() {
        return this.r;
    }

    public int c() {
        return this.c;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        if (address == this) {
            return true;
        }
        return address.r == this.r && address.c == this.c;
    }

    public boolean equals(int rr, int cc) {
        return rr == this.r && cc == this.c;
    }

    public int hashCode() {
        return this.r * 1000 + this.c;
    }

    public boolean isNowhere() {
        return this.r == -1 && this.c == -1;
    }

    @Override
    public int compareTo(Address o) {
        if (this.r < o.r) {
            return -1;
        }
        if (this.r > o.r) {
            return 1;
        }
        if (this.c < o.c) {
            return -1;
        }
        if (this.c > o.c) {
            return 1;
        }
        return 0;
    }

    public static int getDirectionTo(Address pos0, Address pos1) {
        int r0 = pos0.r();
        int r1 = pos1.r();
        int c0 = pos0.c();
        int c1 = pos1.c();
        int ret = -1;
        if (r0 == r1) {
            if (c0 < c1) {
                ret = 3;
            } else if (c0 > c1) {
                ret = 1;
            }
        } else if (c0 == c1) {
            if (r0 < r1) {
                ret = 2;
            } else if (r0 > r1) {
                ret = 0;
            }
        }
        return ret;
    }

    public int getDirectionTo(Address pos) {
        return Address.getDirectionTo(this, pos);
    }

    public static Address nextCell(Address p, int direction) {
        int r = p.r();
        int c = p.c();
        switch (direction) {
            case 0: {
                return Address.address(r - 1, c);
            }
            case 1: {
                return Address.address(r, c - 1);
            }
            case 2: {
                return Address.address(r + 1, c);
            }
            case 3: {
                return Address.address(r, c + 1);
            }
            case 4: {
                return Address.address(r - 1, c - 1);
            }
            case 5: {
                return Address.address(r + 1, c - 1);
            }
            case 6: {
                return Address.address(r + 1, c + 1);
            }
            case 7: {
                return Address.address(r - 1, c + 1);
            }
        }
        return NOWHERE;
    }

    public Address nextCell(int direction) {
        return Address.nextCell(this, direction);
    }

    public String toString() {
        return "[" + this.r + ',' + this.c + ']';
    }
}

