/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.norinori;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelBase;
import pencilbox.norinori.Area;
import pencilbox.norinori.Board;

public class Panel
extends PanelBase {
    private Board board;
    private Area draggingArea;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMarkStyle(3);
        this.successColor = new Color(0xCCEECC);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    Area getDraggingArea() {
        return this.draggingArea;
    }

    void setDraggingArea(Area draggingArea) {
        this.draggingArea = draggingArea;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawCells(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
    }

    private void paintAreas(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.board.getArea(p) == null) {
                g.setColor(this.noAreaColor);
                this.paintCell(g, p);
            } else if (this.board.getArea(p) == this.draggingArea) {
                g.setColor(this.draggingAreaColor);
                this.paintCell(g, p);
            } else if (this.isIndicateErrorMode()) {
                int s = this.board.getArea(p).getBlock().size();
                if (s == 2) {
                    g.setColor(this.successColor);
                } else {
                    g.setColor(this.getBackgroundColor());
                }
                this.paintCell(g, p);
            }
            ++n2;
        }
    }

    protected void drawCells(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int st = this.board.getState(p);
            if (st == -2) {
                int s;
                g.setColor(this.getPaintColor());
                if (this.isIndicateErrorMode() && this.board.getArea(p) != null && (s = this.board.getArea(p).getBlock().size()) > 2) {
                    g.setColor(this.getErrorColor());
                }
                this.paintCell(g, p);
            } else if (st == -1) {
                g.setColor(this.getCircleColor());
                this.placeMark(g, p);
            }
            ++n2;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        g.setColor(this.areaBorderColor);
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int[] nArray = Direction.DN_RT;
            int n3 = Direction.DN_RT.length;
            int n4 = 0;
            while (n4 < n3) {
                int d = nArray[n4];
                Address p1 = p.nextCell(d);
                SideAddress b = SideAddress.get(p, d);
                if (this.board.isSideOn(b) && this.board.getArea(p) != this.board.getArea(p1)) {
                    this.placeSideLine(g, b);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

