/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.EventHandlerManager;
import pencilbox.common.gui.MenuCommand;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PreferenceKey;
import pencilbox.common.gui.TreeMapA;

public class PreferencesCopierBase {
    private String pencilName;
    private Properties properties = new Properties();
    protected static List<PreferenceKey> usedKeys;

    public static PreferencesCopierBase createInstance(PencilType pencilType) {
        PreferencesCopierBase copier;
        try {
            copier = (PreferencesCopierBase)ClassUtil.createInstance(pencilType, "PreferencesCopier");
        }
        catch (PencilBoxClassException ex) {
            copier = new PreferencesCopierBase();
        }
        copier.pencilName = String.valueOf(pencilType.getPencilName()) + '.';
        return copier;
    }

    public void applyCurrentPreferences(MenuCommand command) {
        PanelBase panel = command.getPanelBase();
        EventHandlerManager handler = command.getEventHandlerManager();
        handler.setEditMode(this.getIntProperty(PreferenceKey.EDIT_MODE));
        handler.setSymmetricPlacementMode(this.getBooleanProperty(PreferenceKey.SYMMETRIC_PLACEMENT_MODE));
        handler.setImmediateAnswerCheckMode(this.getBooleanProperty(PreferenceKey.IMMEDIATE_ANSWER_CHECK_MODE));
        panel.setDisplaySize(this.getIntProperty(PreferenceKey.CELL_SIZE));
        panel.changeIndexMode(this.getBooleanProperty(PreferenceKey.INDEX_MODE));
        panel.setGridStyle(this.getIntProperty(PreferenceKey.GRID_STYLE));
        panel.setMarkStyle(this.getIntProperty(PreferenceKey.MARK_STYLE));
        panel.setCursorMode(this.getBooleanProperty(PreferenceKey.CURSOR_MODE));
        panel.setBackgroundColor(this.getColorProperty(PreferenceKey.BACKGROUND_COLOR));
        panel.setGridColor(this.getColorProperty(PreferenceKey.GRID_COLOR));
        for (PreferenceKey key : usedKeys) {
            if (key == PreferenceKey.LINK_WIDTH) {
                panel.setLinkWidth(this.getIntProperty(key));
                continue;
            }
            if (key == PreferenceKey.COUNT_AREA_SIZE_MODE) {
                panel.setCountAreaSizeMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.DOT_HINT_MODE) {
                panel.setDotHintMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.HIDE_SOLE_NUMBER_MODE) {
                panel.setHideSoleNumberMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.HIDE_STAR_MODE) {
                panel.setHideStarMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.HIGHLIGHT_SELECTION_MODE) {
                panel.setHighlightSelectionMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.INDICATE_ERROR_MODE) {
                panel.setIndicateErrorMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.PAINT_ILLUMINATED_CELL_MODE) {
                panel.setPaintIlluminatedCellMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.SEPARATE_AREA_COLOR_MODE) {
                panel.setSeparateAreaColorMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.SEPARATE_LINK_COLOR_MODE) {
                panel.setSeparateLinkColorMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.SEPARATE_TETROMINO_COLOR_MODE) {
                panel.setSeparateTetrominoColorMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.SHOW_AREA_BORDER_MODE) {
                panel.setShowAreaBorderMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.SHOW_BEAM_MODE) {
                panel.setShowBeamMode(this.getBooleanProperty(key));
                continue;
            }
            if (key == PreferenceKey.AREA_BORDER_COLOR) {
                panel.setAreaBorderColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.AREA_PAINT_COLOR) {
                panel.setAreaPaintColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.BLACK_AREA_COLOR) {
                panel.setBlackAreaColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.BORDER_COLOR) {
                panel.setBorderColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.BULB_COLOR) {
                panel.setBulbColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.CROSS_COLOR) {
                panel.setCrossColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.GATE_COLOR) {
                panel.setGateColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.ILLUMINATED_CELL_COLOR) {
                panel.setIlluminatedCellColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.INPUT_COLOR) {
                panel.setInputColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.LINE_COLOR) {
                panel.setLineColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.NO_BULB_COLOR) {
                panel.setNoBulbColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.NO_PAINT_COLOR) {
                panel.setCircleColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.NUMBER_COLOR) {
                panel.setNumberColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.PAINT_COLOR) {
                panel.setPaintColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.WALL_COLOR) {
                panel.setWallColor(this.getColorProperty(key));
                continue;
            }
            if (key == PreferenceKey.WHITE_AREA_COLOR) {
                panel.setWhiteAreaColor(this.getColorProperty(key));
                continue;
            }
            if (key != PreferenceKey.LETTERS) continue;
            panel.setLetters(this.getStringProperty(key));
        }
    }

    public void acquireCurrentPreferences(MenuCommand command) {
        PanelBase panel = command.getPanelBase();
        EventHandlerManager handler = command.getEventHandlerManager();
        this.setIntProperty(PreferenceKey.EDIT_MODE, panel.getEditMode());
        this.setBooleanProperty(PreferenceKey.SYMMETRIC_PLACEMENT_MODE, handler.isSymmetricPlacementMode());
        this.setBooleanProperty(PreferenceKey.IMMEDIATE_ANSWER_CHECK_MODE, handler.isImmediateAnswerCheckMode());
        this.setIntProperty(PreferenceKey.CELL_SIZE, panel.getCellSize());
        this.setBooleanProperty(PreferenceKey.INDEX_MODE, panel.isIndexMode());
        this.setIntProperty(PreferenceKey.GRID_STYLE, panel.getGridStyle());
        this.setIntProperty(PreferenceKey.MARK_STYLE, panel.getMarkStyle());
        this.setBooleanProperty(PreferenceKey.CURSOR_MODE, panel.isCursorMode());
        this.setColorProperty(PreferenceKey.BACKGROUND_COLOR, panel.getBackgroundColor());
        this.setColorProperty(PreferenceKey.GRID_COLOR, panel.getGridColor());
        for (PreferenceKey key : usedKeys) {
            if (key == PreferenceKey.LINK_WIDTH) {
                this.setIntProperty(key, panel.getLinkWidth());
                continue;
            }
            if (key == PreferenceKey.COUNT_AREA_SIZE_MODE) {
                this.setBooleanProperty(key, panel.isCountAreaSizeMode());
                continue;
            }
            if (key == PreferenceKey.DOT_HINT_MODE) {
                this.setBooleanProperty(key, panel.isDotHintMode());
                continue;
            }
            if (key == PreferenceKey.HIGHLIGHT_SELECTION_MODE) {
                this.setBooleanProperty(key, panel.isHighlightSelectionMode());
                continue;
            }
            if (key == PreferenceKey.HIDE_SOLE_NUMBER_MODE) {
                this.setBooleanProperty(key, panel.isHideSoleNumberMode());
                continue;
            }
            if (key == PreferenceKey.HIDE_STAR_MODE) {
                this.setBooleanProperty(key, panel.isHideStarMode());
                continue;
            }
            if (key == PreferenceKey.INDICATE_ERROR_MODE) {
                this.setBooleanProperty(key, panel.isIndicateErrorMode());
                continue;
            }
            if (key == PreferenceKey.PAINT_ILLUMINATED_CELL_MODE) {
                this.setBooleanProperty(key, panel.isPaintIlluminatedCellMode());
                continue;
            }
            if (key == PreferenceKey.SEPARATE_AREA_COLOR_MODE) {
                this.setBooleanProperty(key, panel.isSeparateAreaColorMode());
                continue;
            }
            if (key == PreferenceKey.SEPARATE_LINK_COLOR_MODE) {
                this.setBooleanProperty(key, panel.isSeparateLinkColorMode());
                continue;
            }
            if (key == PreferenceKey.SEPARATE_TETROMINO_COLOR_MODE) {
                this.setBooleanProperty(key, panel.isSeparateTetrominoColorMode());
                continue;
            }
            if (key == PreferenceKey.SHOW_AREA_BORDER_MODE) {
                this.setBooleanProperty(key, panel.isShowAreaBorderMode());
                continue;
            }
            if (key == PreferenceKey.SHOW_BEAM_MODE) {
                this.setBooleanProperty(key, panel.isShowBeamMode());
                continue;
            }
            if (key == PreferenceKey.AREA_BORDER_COLOR) {
                this.setColorProperty(key, panel.getAreaBorderColor());
                continue;
            }
            if (key == PreferenceKey.AREA_PAINT_COLOR) {
                this.setColorProperty(key, panel.getAreaPaintColor());
                continue;
            }
            if (key == PreferenceKey.BLACK_AREA_COLOR) {
                this.setColorProperty(key, panel.getBlackAreaColor());
                continue;
            }
            if (key == PreferenceKey.BORDER_COLOR) {
                this.setColorProperty(key, panel.getBorderColor());
                continue;
            }
            if (key == PreferenceKey.BULB_COLOR) {
                this.setColorProperty(key, panel.getBulbColor());
                continue;
            }
            if (key == PreferenceKey.CROSS_COLOR) {
                this.setColorProperty(key, panel.getCrossColor());
                continue;
            }
            if (key == PreferenceKey.GATE_COLOR) {
                this.setColorProperty(key, panel.getGateColor());
                continue;
            }
            if (key == PreferenceKey.PAINT_COLOR) {
                this.setColorProperty(key, panel.getPaintColor());
                continue;
            }
            if (key == PreferenceKey.ILLUMINATED_CELL_COLOR) {
                this.setColorProperty(key, panel.getIlluminatedCellColor());
                continue;
            }
            if (key == PreferenceKey.INPUT_COLOR) {
                this.setColorProperty(key, panel.getInputColor());
                continue;
            }
            if (key == PreferenceKey.LINE_COLOR) {
                this.setColorProperty(key, panel.getLineColor());
                continue;
            }
            if (key == PreferenceKey.NO_BULB_COLOR) {
                this.setColorProperty(key, panel.getNoBulbColor());
                continue;
            }
            if (key == PreferenceKey.NO_PAINT_COLOR) {
                this.setColorProperty(key, panel.getCircleColor());
                continue;
            }
            if (key == PreferenceKey.NUMBER_COLOR) {
                this.setColorProperty(key, panel.getNumberColor());
                continue;
            }
            if (key == PreferenceKey.WALL_COLOR) {
                this.setColorProperty(key, panel.getWallColor());
                continue;
            }
            if (key == PreferenceKey.WHITE_AREA_COLOR) {
                this.setColorProperty(key, panel.getWhiteAreaColor());
                continue;
            }
            if (key != PreferenceKey.LETTERS) continue;
            this.setStringProperty(key, panel.getLetters());
        }
    }

    public void copyPreferences(MenuCommand src, MenuCommand dst) {
        this.acquireCurrentPreferences(src);
        this.applyCurrentPreferences(dst);
    }

    public void loadPreferences(MenuCommand command, File file) {
        this.acquireCurrentPreferences(command);
        try {
            this.properties.load(new FileInputStream(file));
            this.applyCurrentPreferences(command);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void storePreferences(MenuCommand command, File file) {
        try {
            if (file.canRead()) {
                this.properties.load(new FileInputStream(file));
            }
            this.acquireCurrentPreferences(command);
            TreeMapA map = new TreeMapA(this.properties);
            map.store(new FileOutputStream(file), "PencilBox preferences");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String getStringProperty(PreferenceKey key) {
        return this.properties.getProperty(String.valueOf(this.pencilName) + key.getKey());
    }

    protected boolean getBooleanProperty(PreferenceKey key) {
        return Integer.parseInt(this.properties.getProperty(String.valueOf(this.pencilName) + key.getKey())) > 0;
    }

    protected int getIntProperty(PreferenceKey key) {
        return Integer.parseInt(this.properties.getProperty(String.valueOf(this.pencilName) + key.getKey()));
    }

    protected Color getColorProperty(PreferenceKey key) {
        return Color.decode(this.properties.getProperty(String.valueOf(this.pencilName) + key.getKey()));
    }

    protected void setStringProperty(PreferenceKey key, String value) {
        this.properties.setProperty(String.valueOf(this.pencilName) + key.getKey(), value);
    }

    protected void setBooleanProperty(PreferenceKey key, boolean value) {
        int i = value ? 1 : 0;
        this.properties.setProperty(String.valueOf(this.pencilName) + key.getKey(), Integer.toString(i));
    }

    protected void setIntProperty(PreferenceKey key, int value) {
        this.properties.setProperty(String.valueOf(this.pencilName) + key.getKey(), Integer.toString(value));
    }

    protected void setColorProperty(PreferenceKey key, Color value) {
        this.properties.setProperty(String.valueOf(this.pencilName) + key.getKey(), this.getColorString(value));
    }

    public String getColorString(Color color) {
        return String.format("0x%06X", color.getRGB() & 0xFFFFFF);
    }
}

