/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import pencilbox.common.gui.ImageSelection;
import pencilbox.common.gui.PanelBase;

public class PanelImageTransfer {
    public void copyImage(PanelBase panel) {
        BufferedImage image = this.makePanelImage(panel);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ImageSelection selection = new ImageSelection(image);
        clipboard.setContents(selection, null);
    }

    public BufferedImage makePanelImage(PanelBase panel) {
        BufferedImage image = new BufferedImage(panel.getBoardRegionSize().width, panel.getBoardRegionSize().height, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        panel.drawPanel(g2);
        return image;
    }
}

