/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pencilbox.common.core.UndoManager;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PencilBoxDialog;

public class HistoryDialog
extends PencilBoxDialog {
    private static HistoryDialog instance = new HistoryDialog();
    private JSlider slider;
    private PanelBase panel;
    private UndoManager undoManager;
    private ChangeListener changeListener;

    public static HistoryDialog getInstance() {
        return instance;
    }

    private HistoryDialog() {
    }

    @Override
    protected void makeDialog() {
        this.setDialogType(1);
        super.makeDialog();
        this.makeMainPanel();
    }

    private void makeMainPanel() {
        JPanel mainPanel = new JPanel();
        this.makeSlider();
        mainPanel.add(this.slider);
        this.add((Component)mainPanel, "North");
    }

    private void makeSlider() {
        this.slider = new JSlider(0);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HistoryDialog.this.jumpTo(HistoryDialog.this.slider.getValue());
            }
        };
    }

    public void init(PanelBase p, UndoManager um) {
        this.slider.removeChangeListener(this.changeListener);
        this.panel = p;
        this.undoManager = um;
        int m = um.getEditsSize();
        int k = um.getIndexOfNextAdd();
        this.slider.setMaximum(m);
        int ts = m / 25 + 1;
        this.slider.setMinorTickSpacing(ts);
        this.slider.setMajorTickSpacing(ts * 5);
        this.slider.setLabelTable(this.slider.createStandardLabels(ts * 5));
        this.slider.setValue(k);
        this.slider.addChangeListener(this.changeListener);
    }

    public void jumpTo(int n) {
        this.undoManager.jumpTo(n);
        this.panel.repaint();
    }
}

