/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.factory;

import java.io.File;
import javax.swing.UIManager;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.factory.PencilFactory;
import pencilbox.common.factory.PencilType;

public abstract class Main {
    public void run(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PencilType type = PencilType.getPencilType(this.getClass().getPackage().getName().substring("pencilbox".length() + 1));
        PencilFactory factory = new PencilFactory(type);
        try {
            if (args.length == 0 || args[0].length() == 0) {
                factory.createNewFrame();
            } else {
                int success = 0;
                int i = 0;
                while (i < args.length) {
                    File file = new File(args[i]);
                    if (file.isFile()) {
                        factory.createNewFrame(file);
                        ++success;
                    } else {
                        System.out.println("Cannot read file : " + file.toString());
                    }
                    ++i;
                }
                if (success == 0) {
                    factory.createNewFrame();
                }
            }
        }
        catch (PencilBoxException e) {
            e.printStackTrace();
        }
    }
}

