/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import java.util.Vector;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CompoundStep;

public class UndoManager {
    private Vector<AbstractStep> edits = new Vector();
    private int indexOfNextAdd;
    private BoardBase board;
    private boolean recordUndo = true;
    private boolean compoundUndo = false;
    private CompoundStep currentCompoundEdit = null;

    public UndoManager(BoardBase b) {
        this.edits.ensureCapacity(100);
        this.indexOfNextAdd = 0;
        this.board = b;
    }

    public synchronized void discardAllEdits() {
        this.edits.clear();
        this.indexOfNextAdd = 0;
    }

    protected void trimEdits(int from, int to) {
        if (from <= to) {
            int i = to;
            while (from <= i) {
                this.edits.removeElementAt(i);
                --i;
            }
            if (this.indexOfNextAdd > to) {
                this.indexOfNextAdd -= to - from + 1;
            } else if (this.indexOfNextAdd >= from) {
                this.indexOfNextAdd = from;
            }
        }
    }

    public void setRecordUndo(boolean b) {
        this.recordUndo = b;
    }

    public boolean isRecordUndo() {
        return this.recordUndo;
    }

    public void startCompoundUndo() {
        this.compoundUndo = true;
        this.currentCompoundEdit = new CompoundStep();
    }

    public void stopCompoundUndo() {
        this.compoundUndo = false;
        this.addEdit(this.currentCompoundEdit);
        this.currentCompoundEdit = null;
    }

    protected boolean isCompoundUndo() {
        return this.compoundUndo;
    }

    public synchronized boolean addEdit(AbstractStep edit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        if (this.isCompoundUndo()) {
            this.currentCompoundEdit.attachEdit(edit);
            return true;
        }
        AbstractStep last = this.lastEdit();
        if (last == null || !last.attachEdit(edit)) {
            this.edits.addElement(edit);
        }
        this.indexOfNextAdd = this.edits.size();
        return true;
    }

    protected AbstractStep lastEdit() {
        int count = this.edits.size();
        if (count > 0) {
            return this.edits.elementAt(count - 1);
        }
        return null;
    }

    public synchronized void undo() {
        this.setRecordUndo(false);
        if (this.indexOfNextAdd > 0) {
            AbstractStep edit = this.edits.elementAt(this.indexOfNextAdd - 1);
            if (edit instanceof CompoundStep) {
                Vector<AbstractStep> edits = ((CompoundStep)edit).edits;
                int i = edits.size() - 1;
                while (i >= 0) {
                    this.board.undo(edits.get(i));
                    --i;
                }
            } else {
                this.board.undo(edit);
            }
            --this.indexOfNextAdd;
        }
        this.setRecordUndo(true);
    }

    public synchronized boolean canUndo() {
        return this.indexOfNextAdd > 0;
    }

    public synchronized void redo() {
        this.setRecordUndo(false);
        if (this.indexOfNextAdd < this.edits.size()) {
            AbstractStep edit = this.edits.elementAt(this.indexOfNextAdd);
            if (edit instanceof CompoundStep) {
                Vector<AbstractStep> edits = ((CompoundStep)edit).edits;
                int i = 0;
                while (i < edits.size()) {
                    this.board.redo(edits.get(i));
                    ++i;
                }
            } else {
                this.board.redo(edit);
            }
            ++this.indexOfNextAdd;
        }
        this.setRecordUndo(true);
    }

    public synchronized boolean canRedo() {
        return this.indexOfNextAdd < this.edits.size();
    }

    public int getEditsSize() {
        return this.edits.size();
    }

    public int getIndexOfNextAdd() {
        return this.indexOfNextAdd;
    }

    public void jumpTo(int n) {
        int i;
        if (n >= 0 && n < this.indexOfNextAdd) {
            i = this.indexOfNextAdd - 1;
            while (i >= n) {
                this.undo();
                --i;
            }
        }
        if (n > this.indexOfNextAdd && n <= this.edits.size()) {
            i = this.indexOfNextAdd;
            while (i < n) {
                this.redo();
                ++i;
            }
        }
    }

    public void copyEdits(UndoManager um) {
        UndoManager src = um;
        UndoManager dst = this;
        dst.edits.clear();
        dst.edits.addAll(src.edits);
        dst.indexOfNextAdd = src.indexOfNextAdd;
    }

    public String toString() {
        return " edits: " + this.edits + " indexOfNextAdd: " + this.indexOfNextAdd;
    }
}

