/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shakashaka;

import java.awt.event.MouseEvent;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.shakashaka.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = 0;

    public PanelEventHandler() {
        this.setMaxInputNumber(5);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Address newPos = this.pointToAddress(e);
        if (!this.isOn(newPos)) {
            return;
        }
        int yy = (e.getY() - this.getPanel().getOffsety()) % this.getPanel().getCellSize();
        int xx = (e.getX() - this.getPanel().getOffsetx()) % this.getPanel().getCellSize();
        int corner = xx < this.getPanel().getHalfCellSize() ? (yy < this.getPanel().getHalfCellSize() ? 4 : 5) : (yy < this.getPanel().getHalfCellSize() ? 7 : 6);
        int button = this.getMouseButton(e);
        if (button == 1) {
            this.leftPressed(newPos, corner);
        } else if (button == 3) {
            this.rightPressed(newPos);
        }
        this.moveCursor(newPos);
        this.repaint();
    }

    protected void leftPressed(Address pos, int corner) {
        this.toggleStateCorner(pos, corner);
    }

    @Override
    protected void rightPressed(Address pos) {
        this.toggleStateCorner(pos, -3);
    }

    protected void toggleStateCorner(Address pos, int st) {
        if (Board.isNumber(this.board.getNumber(pos))) {
            return;
        }
        int st0 = this.board.getState(pos);
        if (st == st0) {
            this.board.changeState(pos, 0);
            this.currentState = 0;
        } else {
            this.board.changeState(pos, st);
            this.currentState = st;
        }
    }

    @Override
    protected void leftDragged(Address pos) {
        this.sweepState(pos);
    }

    @Override
    protected void rightDragged(Address pos) {
        this.sweepState(pos);
    }

    private void sweepState(Address pos) {
        if (Board.isNumber(this.board.getNumber(pos))) {
            return;
        }
        if (this.currentState == this.board.getState(pos)) {
            return;
        }
        if (this.currentState == 4 || this.currentState == 6 ? this.board.getState(Address.nextCell(pos, 5)) != this.currentState && this.board.getState(Address.nextCell(pos, 7)) != this.currentState : (this.currentState == 5 || this.currentState == 7) && this.board.getState(Address.nextCell(pos, 4)) != this.currentState && this.board.getState(Address.nextCell(pos, 6)) != this.currentState) {
            return;
        }
        this.board.changeState(pos, this.currentState);
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        this.keyEntered(pos, num);
    }

    @Override
    protected void spaceEntered(Address pos) {
        this.keyEntered(pos, -1);
    }

    @Override
    protected void minusEntered(Address pos) {
        this.keyEntered(pos, -2);
    }

    @Override
    protected void plusEntered(Address pos) {
    }

    @Override
    protected void starEntered(Address pos) {
        this.keyEntered(pos, -3);
    }

    protected void keyEntered(Address pos, int key) {
        int n = 0;
        if (this.isProblemEditMode()) {
            if (key >= 0 && key <= 4) {
                n = key;
            } else if (key == 5) {
                n = -2;
            } else if (key == -2) {
                n = -2;
            } else if (key == -1) {
                n = -1;
            }
            this.board.changeNumber(pos, n);
            if (this.isSymmetricPlacementMode()) {
                Address posS = this.getSymmetricPosition(pos);
                if (n >= 0) {
                    n = -2;
                }
                if (n == -1 && Board.isNumber(this.board.getNumber(posS))) {
                    this.board.changeNumber(posS, -1);
                } else if (n == -2 && !Board.isNumber(this.board.getNumber(posS))) {
                    this.board.changeNumber(posS, -2);
                }
            }
        }
    }
}

