/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shakashaka;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.resource.Messages;
import pencilbox.shakashaka.Area;

public class Board
extends BoardBase {
    public static final int NONUMBER_WALL = -2;
    public static final int WHITE = -3;
    public static final int UNKNOWN = 0;
    public static final int BLANK = -1;
    public static final int OUTER = 6;
    public static final int LTUP = 4;
    public static final int LTDN = 5;
    public static final int RTDN = 6;
    public static final int RTUP = 7;
    public static final Area nullArea = new Area();
    private int[] number;
    private int[] state;
    private Area initializingArea;
    private Area[] areas;
    private List<Area> areaList = new LinkedList<Area>();

    public static final boolean isNumber(int n) {
        return n >= 0 && n <= 4 || n == -2;
    }

    public static final boolean isTriangle(int s) {
        return s >= 4 && s <= 7;
    }

    public static final boolean isFloor(int s) {
        return s == 0 || s == -3;
    }

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows() * this.cols()];
        this.number = new int[this.rows() * this.cols()];
        this.areas = new Area[this.rows() * this.cols()];
        Arrays.fill(this.number, -1);
        Arrays.fill(this.state, 0);
        Arrays.fill(this.areas, nullArea);
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        Arrays.fill(this.state, 0);
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == -3) {
                this.changeState(p, 0);
            }
            ++n2;
        }
    }

    @Override
    public void initBoard() {
        this.initAreas();
    }

    public int getState(int r, int c) {
        return this.getState(this.cell(r, c));
    }

    public int getState(Address pos) {
        return this.getState(this.a2i(pos));
    }

    public int getState(int p) {
        if (this.isOn(p)) {
            return this.state[p];
        }
        return 6;
    }

    public void setState(int r, int c, int st) {
        this.setState(this.cell(r, c), st);
    }

    public void setState(Address pos, int st) {
        this.setState(this.a2i(pos), st);
    }

    private void setState(int p, int st) {
        if (this.isOn(p)) {
            this.state[p] = st;
        }
    }

    public int getNumber(int r, int c) {
        return this.getNumber(this.cell(r, c));
    }

    public int getNumber(Address p) {
        return this.getNumber(this.a2i(p));
    }

    private int getNumber(int i) {
        if (this.isOn(i)) {
            return this.number[i];
        }
        return 6;
    }

    public void setNumber(Address p, int n) {
        this.number[this.cell((Address)p)] = n;
    }

    public void setNumber(int r, int c, int n) {
        this.number[this.cell((int)r, (int)c)] = n;
    }

    public Area getArea(Address p) {
        return this.areas[this.a2i(p)];
    }

    public void setArea(Address p, Area a) {
        this.areas[this.a2i((Address)p)] = a;
    }

    public void changeState(Address p, int st) {
        int prev = this.getState(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.STATE, p, prev, st));
        }
        this.setState(p, st);
        this.initAreas();
    }

    public void changeNumber(Address p, int n) {
        this.changeState(p, 0);
        int prev = this.getNumber(p);
        if (n == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.FIXED, p, prev, n));
        }
        this.setNumber(p, n);
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (step.getType() == AbstractStep.EditType.STATE) {
                this.changeState(s.getPos(), s.getBefore());
            } else if (step.getType() == AbstractStep.EditType.FIXED) {
                this.changeNumber(s.getPos(), s.getBefore());
            }
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (step.getType() == AbstractStep.EditType.STATE) {
                this.changeState(s.getPos(), s.getAfter());
            } else if (step.getType() == AbstractStep.EditType.FIXED) {
                this.changeNumber(s.getPos(), s.getAfter());
            }
        }
    }

    public void initAreas() {
        Arrays.fill(this.areas, nullArea);
        this.areaList.clear();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (!Board.isNumber(this.getNumber(p)) && this.getArea(p) == nullArea) {
                this.initArea(p);
            }
            ++n2;
        }
    }

    public int initArea(Address p) {
        this.initializingArea = new Area();
        int n = this.visit(p, -1);
        this.areaList.add(this.initializingArea);
        for (Address q : this.initializingArea) {
            this.setArea(q, this.initializingArea);
        }
        return n;
    }

    public int checkRectangleArea(Area a) {
        return a.checkRectangleArea();
    }

    private int visit(Address p, int d) {
        int n = 1;
        this.setArea(p, this.initializingArea);
        this.initializingArea.add(p);
        this.initializingArea.updateMinMax(p);
        int s = this.getState(p);
        if (s != 0 && s != -3 && (s == 4 || s == 5 || s == 6 || s == 7)) {
            int n2 = s;
            this.initializingArea.nAreaBorder[n2] = this.initializingArea.nAreaBorder[n2] + 1;
        }
        int dd = 0;
        while (dd < 4) {
            if ((dd != 0 || s != 4 && s != 7) && (dd != 1 || s != 5 && s != 4) && (dd != 2 || s != 6 && s != 5) && (dd != 3 || s != 7 && s != 6)) {
                Address pp = Address.nextCell(p, dd);
                int ss = this.getState(pp);
                if (!this.isOn(pp)) {
                    int n3 = dd;
                    this.initializingArea.nAreaBorder[n3] = this.initializingArea.nAreaBorder[n3] + 1;
                } else if (Board.isNumber(this.getNumber(pp))) {
                    int n4 = dd;
                    this.initializingArea.nAreaBorder[n4] = this.initializingArea.nAreaBorder[n4] + 1;
                } else if (dd == 0 && (ss == 5 || ss == 6) || dd == 1 && (ss == 6 || ss == 7) || dd == 2 && (ss == 7 || ss == 4) || dd == 3 && (ss == 4 || ss == 5)) {
                    int n5 = dd;
                    this.initializingArea.nAreaBorder[n5] = this.initializingArea.nAreaBorder[n5] + 1;
                } else if (this.getArea(pp) != this.initializingArea) {
                    n += this.visit(pp, dd);
                }
            }
            ++dd;
        }
        return n;
    }

    public int countAdjacentTriangles(Address p) {
        int count = 0;
        int d = 0;
        while (d < 4) {
            int s;
            Address pp = Address.nextCell(p, d);
            if (this.isOn(pp) && Board.isTriangle(s = this.getState(Address.nextCell(p, d)))) {
                ++count;
            }
            ++d;
        }
        return count;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int n3 = this.getNumber(p);
            if (n3 >= 0 && n3 <= 4 && this.countAdjacentTriangles(p) != n3) {
                result |= 1;
            }
            ++n2;
        }
        this.initAreas();
        for (Area a : this.areaList) {
            int ret = this.checkRectangleArea(a);
            if (ret >= 0) continue;
            result |= 2;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("shakashaka.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("shakashaka.AnswerCheckMessage2"));
        }
        return message.toString();
    }

    public Address i2a(int i) {
        return Address.address(i / this.cols(), i % this.cols());
    }

    public int a2i(Address a) {
        return this.cell(a.r(), a.c());
    }

    public boolean isOn(int p) {
        return p >= 0 && p < this.rows() * this.cols();
    }

    public int cell(Address p) {
        return this.cell(p.r(), p.c());
    }

    public int cell(int r, int c) {
        if (r < 0 || c < 0 || r >= this.rows() || c >= this.cols()) {
            return -1;
        }
        return r * this.cols() + c;
    }
}

