/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.numberlink;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelBase;
import pencilbox.numberlink.Board;
import pencilbox.numberlink.Link;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private Link selectedLink = null;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected Link getSelectedLink() {
        return this.selectedLink;
    }

    protected void setSelectedLink(Link selectedLink) {
        this.selectedLink = selectedLink;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawGrid(g);
        this.drawLinks(g);
        this.drawNumbers(g);
        this.drawBoardBorder(g);
    }

    private void drawLinks(Graphics2D g) {
        SideAddress[] sideAddressArray = this.board.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            int state = this.board.getState(p);
            if (state == 1) {
                this.placeLink1(g, p);
            }
            ++n2;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int number = this.board.getNumber(p);
            if (number > 0) {
                g.setColor(this.getBackgroundColor());
                this.placeFilledCircle(g, p);
                g.setColor(this.getNumberColor());
                this.placeNumber1(g, p, number);
            } else if (number == -1) {
                g.setColor(this.getNumberColor());
                this.placeBoldCircle(g, p);
            }
            ++n2;
        }
    }

    private void placeLink1(Graphics2D g, SideAddress p) {
        Link link = this.board.getLink(p);
        int linkNo = link.getNumber();
        g.setColor(this.getLineColor());
        if (this.isSeparateLinkColorMode()) {
            if (linkNo == 0) {
                g.setColor(this.getLineColor());
            } else if (linkNo == -1) {
                g.setColor(this.getErrorColor());
            } else {
                g.setColor(Colors.getDarkColor(linkNo));
            }
        }
        if (this.isHighlightSelectionMode() && (linkNo > 0 && linkNo == this.getSelectedNumber() || link == this.getSelectedLink())) {
            g.setColor(this.highlightColor);
        }
        super.placeLink(g, p);
    }

    private void placeNumber1(Graphics2D g, Address p, int n) {
        if (this.isHighlightSelectionMode() && n == this.getSelectedNumber()) {
            g.setColor(this.highlightColor);
            super.paintCell(g, p);
        }
        g.setColor(this.getNumberColor());
        if (this.isSeparateLinkColorMode()) {
            g.setColor(Colors.getDarkColor(this.board.getNumber(p)));
        }
        super.placeNumber(g, p, n);
    }
}

