/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BorderEditStep;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.SideAddress;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;
import pencilbox.yajilin.Link;

public class Board
extends BoardBase {
    static final int UNKNOWN = 0;
    static final int LINE = 1;
    static final int NOLINE = -1;
    static final int BLANK = -3;
    static final int WHITE = -1;
    static final int BLACK = -2;
    static final int OUTER = -9;
    static final int UNDECIDED_NUMBER = -4;
    private static final int ARROW_SHIFT = 4;
    private static final int NUMBER_MASK = 15;
    private int[][] number;
    private int[][][] state;
    private List<Link> linkList;
    private Link[][][] link;
    private Link initializingLink;

    @Override
    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        ArrayUtil.initArrayInt2(this.number, -3);
        this.state = new int[2][][];
        this.state[0] = new int[this.rows()][this.cols() - 1];
        this.state[1] = new int[this.rows() - 1][this.cols()];
        this.linkList = new LinkedList<Link>();
        this.link = new Link[2][][];
        this.link[0] = new Link[this.rows()][this.cols() - 1];
        this.link[1] = new Link[this.rows() - 1][this.cols()];
    }

    public boolean isBlack(Address p) {
        return this.isOn(p) && this.getNumber(p) == -2;
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public int getArrowNumber(Address p) {
        int n = this.getNumber(p);
        return n >= 0 ? n & 0xF : -1;
    }

    public void setArrowNumber(Address p, int n) {
        this.setNumber(p, n);
    }

    public int getArrowDirection(Address p) {
        int n = this.getNumber(p);
        return n >= 0 ? n >> 4 & 3 : -1;
    }

    public void setArrowDirection(Address p, int dir) {
        if (dir < 0 || dir > 3) {
            return;
        }
        int n = this.getNumber(p) & 0xFFFFFFCF | dir << 4;
        this.setNumber(p, n);
    }

    public boolean isNumber(Address p) {
        int n = this.getNumber(p);
        return n >= 0 || n == -4;
    }

    public boolean hasNumberOrBlack(SideAddress b) {
        int d = 0;
        while (d < 2) {
            Address p = SideAddress.nextCellFromBorder(b, d);
            if (this.isNumber(p) || this.isBlack(p)) {
                return true;
            }
            ++d;
        }
        return false;
    }

    public void eraseNumber(Address p) {
        this.setNumber(p, -3);
    }

    public void enterNumber(Address p, int n) {
        int v = -99;
        if (n >= 0) {
            int t = this.getArrowDirection(p);
            if (this.getArrowNumber(p) == n) {
                t = (t + 1) % 4;
            }
            v = Board.getNumberValue(n, t);
        } else if (n == -4) {
            v = n;
        } else if (n == -3) {
            v = n;
        }
        if (v != -3) {
            this.eraseLinesAround(p);
        }
        this.changeNumber(p, v);
    }

    static int getNumberValue(int n, int d) {
        if (d >= 0 && d <= 3) {
            n &= 0xFFFFFFCF;
            n |= d << 4;
        }
        return n;
    }

    int[][][] getState() {
        return this.state;
    }

    public int getState(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.state[d][r][c];
        }
        return -9;
    }

    public int getState(SideAddress pos) {
        return this.getState(pos.d(), pos.r(), pos.c());
    }

    public void setState(int d, int r, int c, int st) {
        if (this.isSideOn(d, r, c)) {
            this.state[d][r][c] = st;
        }
    }

    public void setState(SideAddress pos, int st) {
        this.setState(pos.d(), pos.r(), pos.c(), st);
    }

    public Link getLink(SideAddress p) {
        if (this.isSideOn(p)) {
            return this.link[p.d()][p.r()][p.c()];
        }
        return null;
    }

    public Link getLink(Address p) {
        int d = 0;
        while (d < 4) {
            Link link = this.getLink(SideAddress.get(p, d));
            if (link != null) {
                return link;
            }
            ++d;
        }
        return null;
    }

    public void setLink(SideAddress p, Link l) {
        this.link[p.d()][p.r()][p.c()] = l;
    }

    void eraseLinesAround(Address p) {
        int d = 0;
        while (d < 4) {
            SideAddress side = SideAddress.get(p, d);
            if (this.getState(side) == 1) {
                this.changeState(side, 0);
            }
            ++d;
        }
    }

    public void changeNumber(Address p, int st) {
        int prev = this.getNumber(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(p, prev, st));
        }
        this.setNumber(p, st);
    }

    public void changeState(SideAddress p, int st) {
        int prev = this.getState(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new BorderEditStep(p, prev, st));
        }
        this.setState(p, st);
        if (prev == 1) {
            this.cutLink(p);
        }
        if (st == 1) {
            this.connectLink(p);
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeState(s.getPos(), s.getBefore());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeState(s.getPos(), s.getAfter());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getAfter());
        }
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt3(this.state, 0);
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (!this.isNumber(p)) {
                this.setNumber(p, -3);
            }
            ++n2;
        }
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getNumber(p) == -1) {
                this.changeNumber(p, -3);
            }
            ++n2;
        }
    }

    @Override
    public void initBoard() {
        this.initLinks();
    }

    void initLinks() {
        Link.resetId();
        this.linkList.clear();
        ArrayUtil.initArrayObject2(this.link[0], null);
        ArrayUtil.initArrayObject2(this.link[1], null);
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.initLink(p);
            ++n2;
        }
    }

    boolean isBlock(Address p) {
        int d = 0;
        while (d < 4) {
            Address p1 = p.nextCell(d);
            if (this.isBlack(p1)) {
                return true;
            }
            ++d;
        }
        return false;
    }

    void initLink(Address p) {
        this.initializingLink = new Link();
        int d = 0;
        while (d < 4) {
            this.initLink1(SideAddress.get(p, d));
            ++d;
        }
        if (!this.initializingLink.isEmpty()) {
            this.linkList.add(this.initializingLink);
        }
    }

    private void initLink1(SideAddress p) {
        if (!this.isSideOn(p)) {
            return;
        }
        if (this.getState(p) != 1) {
            return;
        }
        if (this.getLink(p) != null) {
            return;
        }
        this.initializingLink.add(p);
        this.setLink(p, this.initializingLink);
        int d = 0;
        while (d < 6) {
            this.initLink1(SideAddress.nextBorder(p, d));
            ++d;
        }
    }

    void connectLink(SideAddress p) {
        Link link;
        Link newLink = new Link();
        int d = 0;
        while (d < 2) {
            link = this.getLink(SideAddress.nextCellFromBorder(p, d));
            if (link != null && link.size() > newLink.size()) {
                newLink = link;
            }
            ++d;
        }
        if (newLink.isEmpty()) {
            this.linkList.add(newLink);
        }
        d = 0;
        while (d < 2) {
            link = this.getLink(SideAddress.nextCellFromBorder(p, d));
            if (link != null && link != newLink) {
                for (SideAddress b : link) {
                    this.setLink(b, newLink);
                    newLink.add(b);
                }
                this.linkList.remove(link);
            }
            ++d;
        }
        newLink.add(p);
        this.setLink(p, newLink);
    }

    void cutLink(SideAddress p) {
        Link oldLink = this.getLink(p);
        Link longerLink = new Link();
        for (SideAddress b : oldLink) {
            this.setLink(b, null);
        }
        this.linkList.remove(oldLink);
        int d = 0;
        while (d < 2) {
            Address p1 = SideAddress.nextCellFromBorder(p, d);
            this.initLink(p1);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
            ++d;
        }
        longerLink.setId(oldLink.getId());
    }

    public int countLine(Address p) {
        int no = 0;
        int d = 0;
        while (d < 4) {
            SideAddress b = SideAddress.get(p, d);
            if (this.isSideOn(b) && this.getState(b) == 1) {
                ++no;
            }
            ++d;
        }
        return no;
    }

    private int checkLinks() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int l = this.countLine(p);
            if (l > 2) {
                result |= 1;
            } else if (l == 1) {
                result |= 2;
            }
            if (this.isBlack(p) && l > 0) {
                result |= 0x40;
            }
            if (!this.isNumber(p) && !this.isBlack(p) && l == 0) {
                result |= 8;
            }
            ++n2;
        }
        if (this.linkList.size() > 1) {
            result |= 4;
        }
        return result;
    }

    private int checkArrows() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getNumber(p) >= 0) {
                result |= this.checkArrow(p);
            }
            if (this.isBlack(p) && this.isBlock(p)) {
                result |= 0x20;
            }
            ++n2;
        }
        return result;
    }

    int checkArrow(Address p0) {
        int result = 0;
        int blackCount = 0;
        int dir = this.getArrowDirection(p0);
        int number = this.getArrowNumber(p0);
        Address p = Address.nextCell(p0, dir);
        while (this.isOn(p)) {
            if (this.isBlack(p)) {
                ++blackCount;
            }
            p = Address.nextCell(p, dir);
        }
        result = number == blackCount ? 0 : 16;
        return result;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        result |= this.checkLinks();
        return result |= this.checkArrows();
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("yajilin.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("yajilin.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("yajilin.AnswerCheckMessage3"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("yajilin.AnswerCheckMessage4"));
        }
        if ((result & 0x40) == 64) {
            message.append(Messages.getString("yajilin.AnswerCheckMessage7"));
        }
        if ((result & 0x20) == 32) {
            message.append(Messages.getString("yajilin.AnswerCheckMessage6"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("yajilin.AnswerCheckMessage5"));
        }
        return message.toString();
    }
}

