/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import pencilbox.common.gui.PanelBase;

class PrintPreviewCanvas
extends JPanel
implements Printable {
    Printable printObject;
    PageFormat pageFormat;
    double scaling = 0.7;
    int repeatX = 1;
    int repeatY = 1;

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pf.getImageableX(), pf.getImageableY());
        this.drawPanel(g2);
        return 0;
    }

    public void paintComponent(Graphics g) {
        double yoff;
        double xoff;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        double px = this.pageFormat.getWidth();
        double py = this.pageFormat.getHeight();
        double scale = 1.0;
        double sx = this.getWidth() - 1;
        double sy = this.getHeight() - 1;
        if (px / py < sx / sy) {
            scale = sy / py;
            xoff = 0.5 * (sx - scale * px);
            yoff = 0.0;
        } else {
            scale = sx / px;
            xoff = 0.0;
            yoff = 0.5 * (sy - scale * py);
        }
        g2.translate(xoff, yoff);
        g2.scale(scale, scale);
        Rectangle2D.Double pageOutline = new Rectangle2D.Double(0.0, 0.0, px, py);
        g2.setPaint(Color.white);
        g2.fill(pageOutline);
        g2.setPaint(Color.black);
        g2.draw(pageOutline);
        g2.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
        this.drawPanel(g2);
    }

    private void drawPanel(Graphics2D g2) {
        g2.scale(this.scaling, this.scaling);
        if (this.printObject instanceof PanelBase) {
            PanelBase p = (PanelBase)this.printObject;
            Dimension d = p.getBoardRegionSize();
            int r = 0;
            while (r < this.repeatY) {
                int c = 0;
                while (c < this.repeatX) {
                    p.drawPanel(g2);
                    g2.translate(d.width + p.getCellSize(), 0);
                    ++c;
                }
                g2.translate((d.width + p.getCellSize()) * -this.repeatX, d.height + p.getCellSize());
                ++r;
            }
        }
    }
}

