/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import pencilbox.common.core.BoardBase;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.common.gui.RegionEditHandler;

public class EventHandlerManager {
    private PanelBase panel;
    private PanelEventHandlerBase handler;
    private RegionEditHandler regionEditHandler;

    public EventHandlerManager(PencilType pencilType) throws PencilBoxClassException {
        this.handler = (PanelEventHandlerBase)ClassUtil.createInstance(pencilType, "PanelEventHandler");
        this.regionEditHandler = new RegionEditHandler();
    }

    public void setup(PanelBase panel, BoardBase board) {
        this.panel = panel;
        this.handler.setup(panel, board);
        this.regionEditHandler.setup(panel, board, this);
        this.setEditMode(panel.getEditMode());
    }

    public boolean isSymmetricPlacementMode() {
        return this.handler.isSymmetricPlacementMode();
    }

    public void setSymmetricPlacementMode(boolean b) {
        this.handler.setSymmetricPlacementMode(b);
    }

    public boolean isImmediateAnswerCheckMode() {
        return this.handler.isImmediateAnswerCheckMode();
    }

    public void setImmediateAnswerCheckMode(boolean b) {
        this.handler.setImmediateAnswerCheckMode(b);
    }

    public void resetImmediateAnswerCheckMode() {
        this.handler.resetImmediateAnswerCheckMode();
    }

    public void checkAnswer() {
        this.handler.checkAnswer();
    }

    public void setEditMode(int mode) {
        int currentMode = this.panel.getEditMode();
        if (currentMode == PanelBase.PROBLEM_INPUT_MODE || currentMode == PanelBase.ANSWER_INPUT_MODE) {
            this.removeListenerFromPanel(this.handler);
        } else if (currentMode == PanelBase.REGION_EDIT_MODE) {
            this.removeListenerFromPanel(this.regionEditHandler);
        }
        if (mode == PanelBase.PROBLEM_INPUT_MODE || mode == PanelBase.ANSWER_INPUT_MODE) {
            this.addListenerToPanel(this.handler);
            this.handler.resetPreviousInput();
            this.resetImmediateAnswerCheckMode();
        } else if (mode == PanelBase.REGION_EDIT_MODE) {
            this.addListenerToPanel(this.regionEditHandler);
            this.regionEditHandler.init();
        }
        this.panel.setEditMode(mode);
    }

    private void addListenerToPanel(EventListener l) {
        if (l instanceof MouseListener) {
            this.panel.addMouseListener((MouseListener)l);
        }
        if (l instanceof MouseMotionListener) {
            this.panel.addMouseMotionListener((MouseMotionListener)l);
        }
        if (l instanceof KeyListener) {
            // empty if block
        }
        this.panel.addKeyListener((KeyListener)l);
    }

    private void removeListenerFromPanel(EventListener l) {
        if (l instanceof MouseListener) {
            this.panel.removeMouseListener((MouseListener)l);
        }
        if (l instanceof MouseMotionListener) {
            this.panel.removeMouseMotionListener((MouseMotionListener)l);
        }
        if (l instanceof KeyListener) {
            // empty if block
        }
        this.panel.removeKeyListener((KeyListener)l);
    }
}

