/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.Address;
import pencilbox.common.io.PzprWriterBase;
import pencilbox.kakuro.Board;

public class PzprWriter
extends PzprWriterBase {
    private Board bd;

    protected String getPzprName() {
        return "kakuro";
    }

    protected void pzlexport() {
        this.bd = (Board)this.boardBase;
        this.outSize(this.bd.rows() - 1, this.bd.cols() - 1);
        this.encodeKakuro();
    }

    protected void encodeKakuro() {
        String cm = "";
        int count = 0;
        int c = 0;
        while (c < this.rows * this.cols) {
            String pstr = "";
            if (this.QuC(c) == 51) {
                pstr = this.QnC(c) <= 0 && this.DiC(c) <= 0 ? "." : this.encval(this.DiC(c)) + this.encval(this.QnC(c));
            } else {
                pstr = " ";
                ++count;
            }
            if (count == 0) {
                cm = String.valueOf(cm) + pstr;
            } else if (pstr != " ") {
                cm = String.valueOf(cm) + PzprWriter.toString(count + 19, 36) + pstr;
                count = 0;
            } else if (count == 16) {
                cm = String.valueOf(cm) + "z";
                count = 0;
            }
            ++c;
        }
        if (count > 0) {
            cm = String.valueOf(cm) + PzprWriter.toString(count + 19, 36);
        }
        c = 0;
        while (c < this.cols) {
            if (this.QuC(this.cnum(c, 0)) != 51) {
                cm = String.valueOf(cm) + this.encval(this.DiE(c));
            }
            ++c;
        }
        c = this.cols;
        while (c < this.cols + this.rows) {
            if (this.QuC(this.cnum(0, c - this.cols)) != 51) {
                cm = String.valueOf(cm) + this.encval(this.QnE(c));
            }
            ++c;
        }
        this.outbstr(cm);
    }

    String encval(int val) {
        if (val >= 1 && val <= 19) {
            return PzprWriter.toString(val, 36).toLowerCase();
        }
        if (val >= 20 && val <= 45) {
            return PzprWriter.toString(val - 10, 36).toUpperCase();
        }
        return "0";
    }

    public int cnum(int cx, int cy) {
        return cx >= 0 && cx <= this.cols - 1 && cy >= 0 && cy <= this.rows - 1 ? cx + cy * this.cols : -1;
    }

    protected int QuC(int i) {
        if (this.bd.isWall(this.i2aKK(i))) {
            return 51;
        }
        return -1;
    }

    protected int QnC(int i) {
        int n = this.bd.getSum(this.i2aKK(i), 1);
        return n;
    }

    protected int DiC(int i) {
        int n = this.bd.getSum(this.i2aKK(i), 0);
        return n;
    }

    protected int QnE(int i) {
        int n = 0;
        if (i >= 0 && i < this.cols) {
            n = this.bd.getSum(Address.address(0, i + 1), 1);
        } else if (i >= this.cols && i < this.cols + this.rows) {
            n = this.bd.getSum(Address.address(i - this.cols + 1, 0), 1);
        }
        return n;
    }

    protected int DiE(int i) {
        int n = 0;
        if (i >= 0 && i < this.cols) {
            n = this.bd.getSum(Address.address(0, i + 1), 0);
        } else if (i >= this.cols && i < this.cols + this.rows) {
            n = this.bd.getSum(Address.address(i - this.cols + 1, 0), 0);
        }
        return n;
    }

    protected Address i2aKK(int i) {
        return Address.address(i / this.cols + 1, i % this.cols + 1);
    }
}

