/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.lits;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.lits.Area;
import pencilbox.lits.Board;
import pencilbox.lits.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = 0;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    Area getDraggingArea() {
        return ((Panel)this.getPanel()).getDraggingArea();
    }

    void setDraggingArea(Area draggingArea) {
        ((Panel)this.getPanel()).setDraggingArea(draggingArea);
    }

    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area area = this.board.getArea(pos);
            if (area == null) {
                area = new Area();
                this.board.addCellToArea(pos, area);
            }
            this.setDraggingArea(area);
        } else {
            this.toggleState(pos, -2);
            this.currentState = this.board.getState(pos);
        }
    }

    protected void leftDragged(Address pos) {
        if (this.isProblemEditMode()) {
            Area draggingArea = this.getDraggingArea();
            if (draggingArea == null) {
                return;
            }
            Area oldArea = this.board.getArea(pos);
            if (oldArea != null && oldArea != draggingArea) {
                this.board.removeCellFromArea(pos, oldArea);
                this.board.addCellToArea(pos, draggingArea);
            } else if ((oldArea == null || oldArea != draggingArea) && oldArea == null) {
                this.board.addCellToArea(pos, draggingArea);
            }
        } else {
            this.sweepState(pos);
        }
    }

    protected void rightPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area oldArea = this.board.getArea(pos);
            if (oldArea != null) {
                this.board.removeCellFromArea(pos, oldArea);
            }
        } else {
            this.toggleState(pos, -1);
            this.currentState = this.board.getState(pos);
        }
    }

    protected void rightDragged(Address pos) {
        if (this.isProblemEditMode()) {
            this.rightPressed(pos);
        } else {
            this.sweepState(pos);
        }
    }

    protected void leftReleased(Address dragEnd) {
        this.setDraggingArea(null);
    }

    private void toggleState(Address pos, int st) {
        if (st == this.board.getState(pos)) {
            st = 0;
        }
        this.board.changeStateA(pos, st);
    }

    private void sweepState(Address pos) {
        int st = this.board.getState(pos);
        if (st == this.currentState) {
            return;
        }
        this.board.changeStateA(pos, this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        this.isProblemEditMode();
    }

    protected void spaceEntered(Address pos) {
        this.isProblemEditMode();
    }

    protected void minusEntered(Address pos) {
        this.isProblemEditMode();
    }
}

