/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.lits;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.lits.Panel;
import pencilbox.resource.Messages;

public class Menu
extends MenuBase {
    private JMenuItem areaBorderColorItem;
    private JMenuItem paintColorItem;
    private JMenuItem circleColorItem;
    private JMenuItem separateTetrominoColorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    protected void buildViewMenu() {
        this.addNoPaintMarkStyleMenu();
        super.buildViewMenu();
        this.areaBorderColorItem = this.addColorMenuItem(Messages.getString("Menu.areaBorderColorItem"));
        this.paintColorItem = this.addColorMenuItem(Messages.getString("Menu.paintColorItem"));
        this.circleColorItem = this.addColorMenuItem(Messages.getString("Menu.noPaintColorItem"));
        this.separateTetrominoColorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.separateTetrominoColorItem"), 'D', false);
        this.addToViewMenu(this.separateTetrominoColorItem);
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.separateTetrominoColorItem) {
            this.getPanel().setSeparateTetrominoColorMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.paintColorItem) {
            return this.getPanel().getPaintColor();
        }
        if (target == this.circleColorItem) {
            return this.getPanel().getCircleColor();
        }
        if (target == this.areaBorderColorItem) {
            return this.getPanel().getAreaBorderColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.paintColorItem) {
            this.getPanel().setPaintColor(color);
        } else if (target == this.circleColorItem) {
            this.getPanel().setCircleColor(color);
        } else if (target == this.areaBorderColorItem) {
            this.getPanel().setAreaBorderColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.separateTetrominoColorItem.setSelected(this.getPanel().isSeparateTetrominoColorMode());
    }
}

