/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.io.PzprReaderBase;
import pencilbox.heyawake.Board;
import pencilbox.heyawake.Square;

public class PzprReader
extends PzprReaderBase {
    private Board bd;
    private Area[] areaArray;
    private Square[] squareArray;
    int nSquare;

    protected BoardBase makeBoard() {
        this.bd = new Board();
        this.bd.setSize(this.rows, this.cols);
        return this.bd;
    }

    protected void pzlimport() {
        this.decodeBorder();
        this.makeAreaIDsFromBorders();
        this.makeAreas();
        this.makeSquares();
        this.roomNumbers = new int[this.squareArray.length];
        int l = 0;
        while (l < this.squareArray.length) {
            this.roomNumbers[l] = -1;
            ++l;
        }
        this.decodeRoomNumber16();
        l = 0;
        while (l < this.squareArray.length) {
            if (this.roomNumbers[l] >= 0) {
                this.squareArray[l].setNumber(this.roomNumbers[l]);
            }
            ++l;
        }
    }

    protected void sQnC(int id, int num) {
        this.bd.getSquare(this.i2a(id)).setNumber(num);
    }

    private void makeAreas() {
        this.areaArray = new Area[this.nArea];
        int k = 0;
        while (k < this.nArea) {
            this.areaArray[k] = new Area();
            ++k;
        }
        int i = 0;
        while (i < this.bd.rows() * this.bd.cols()) {
            int k2 = this.areaIds[i] - 1;
            this.areaArray[k2].add(this.i2a(i));
            ++i;
        }
    }

    private void makeSquares() {
        this.squareArray = new Square[this.nArea];
        this.nSquare = 0;
        int k = 0;
        while (k < this.nArea) {
            Square sq = this.makeCircumscribedSquare(this.areaArray[k]);
            if (sq.getSquareSize() == this.areaArray[k].size()) {
                this.squareArray[this.nSquare] = sq;
                ++this.nSquare;
                this.bd.addSquare(sq);
            } else {
                System.out.println("\u9818\u57df\u304c\u56db\u89d2\u5f62\u3067\u306a\u3044");
            }
            ++k;
        }
    }

    public Square makeCircumscribedSquare(Area area) {
        int r1 = this.bd.cols();
        int r2 = -1;
        int c1 = this.bd.rows();
        int c2 = -1;
        for (Address a : area) {
            if (r1 > a.r()) {
                r1 = a.r();
            }
            if (r2 < a.r()) {
                r2 = a.r();
            }
            if (c1 > a.c()) {
                c1 = a.c();
            }
            if (c2 >= a.c()) continue;
            c2 = a.c();
        }
        return new Square(r1, c1, r2, c2);
    }
}

