/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.hashi.Bridge;
import pencilbox.hashi.BridgeEditStep;
import pencilbox.hashi.Pier;
import pencilbox.resource.Messages;

public class Board
extends BoardBase {
    static final int UNDECIDED_NUMBER = 9;
    private Pier[][] pier;
    private Bridge[][] bridgeV;
    private Bridge[][] bridgeH;
    private int maxChain;
    private int nPier;
    private int nBridge;
    static final String ERR_CROSS_BRIDGE = Messages.getString("hashi.AnswerCheckMessage1");
    static final String YET_MULTIPLE_LINE = Messages.getString("hashi.AnswerCheckMessage2");
    static final String ERR_WRONG_NUMBER = Messages.getString("hashi.AnswerCheckMessage3");

    protected void setup() {
        super.setup();
        this.bridgeV = new Bridge[this.rows()][this.cols()];
        this.bridgeH = new Bridge[this.rows()][this.cols()];
        this.pier = new Pier[this.rows()][this.cols()];
        this.maxChain = 1;
        this.nPier = 0;
        this.nBridge = 0;
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c)) {
                    this.pier[r][c].clear();
                }
                ++c;
            }
            ++r;
        }
    }

    public void initBoard() {
        this.initChain();
    }

    public void setNumber(int r, int c, int n) {
        if (n == 0) {
            if (this.isPier(r, c)) {
                this.removePier(r, c);
            }
        } else if (n > 0) {
            if (this.isPier(r, c)) {
                this.pier[r][c].setNumber(n);
            } else {
                this.addPier(r, c, n);
            }
        }
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public int getNumber(int r, int c) {
        if (this.pier[r][c] == null) {
            return 0;
        }
        return this.pier[r][c].getNumber();
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public boolean isPier(int r, int c) {
        return this.pier[r][c] != null;
    }

    public boolean isPier(Address pos) {
        return this.isPier(pos.r(), pos.c());
    }

    public int getState(int r, int c) {
        int ret = 0;
        if (this.bridgeV[r][c] != null) {
            ret += this.bridgeV[r][c].getBridge();
        }
        if (this.bridgeH[r][c] != null) {
            ret += this.bridgeH[r][c].getBridge() << 2;
        }
        return ret;
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int n) {
        if (this.bridgeV[r][c] != null) {
            this.bridgeV[r][c].setBridge(n & 3);
        }
        if (this.bridgeH[r][c] != null) {
            this.bridgeH[r][c].setBridge(n >> 2 & 3);
        }
    }

    public void setState(Address pos, int n) {
        this.setState(pos.r(), pos.c(), n);
    }

    public int getVertBridge(int r, int c) {
        if (this.bridgeV[r][c] == null) {
            return -1;
        }
        return this.bridgeV[r][c].getBridge();
    }

    public int getHorizBridge(int r, int c) {
        if (this.bridgeH[r][c] == null) {
            return -1;
        }
        return this.bridgeH[r][c].getBridge();
    }

    public boolean hasCrossedBridge(int r, int c) {
        return this.getHorizBridge(r, c) > 0 && this.getVertBridge(r, c) > 0;
    }

    public Pier getPier(int r, int c) {
        return this.pier[r][c];
    }

    public Bridge getBridge(int r, int c, int dir) {
        if (dir == 1) {
            return this.bridgeH[r][c];
        }
        if (dir == 0) {
            return this.bridgeV[r][c];
        }
        return null;
    }

    public void setBridge(int r, int c, int dir, Bridge b) {
        if (dir == 1) {
            this.bridgeH[r][c] = b;
        } else if (dir == 0) {
            this.bridgeV[r][c] = b;
        }
    }

    void setBridge(Address pos0, Address pos1, int d, Bridge b) {
        Address pos = Address.address(pos0);
        while (!(pos = pos.nextCell(d)).equals(pos1)) {
            this.setBridge(pos.r(), pos.c(), d & 1, b);
        }
    }

    void addPier(int r, int c, int n) {
        Pier p;
        this.pier[r][c] = p = new Pier(r, c, n);
        int d = 0;
        while (d < 4) {
            Pier next = this.findPier(r, c, d);
            if (next != null) {
                next.setNextPier(d ^ 2, p);
                p.setNextPier(d, next);
                Bridge b = new Bridge(p, next);
                next.setBridge(d ^ 2, b);
                p.setBridge(d, b);
                this.setBridge(p.getPos(), next.getPos(), d, b);
                ++this.nBridge;
            }
            ++d;
        }
        ++this.nPier;
    }

    void removePier(int r, int c) {
        Pier p2;
        Pier p1;
        Pier p = this.pier[r][c];
        int d = 0;
        while (d < 4) {
            p1 = p.getNextPier(d);
            p2 = p.getNextPier(d ^ 2);
            if (p1 != null) {
                if (p2 != null) {
                    p1.setNextPier(d ^ 2, p2);
                } else {
                    p1.setNextPier(d ^ 2, null);
                }
            }
            ++d;
        }
        d = 0;
        while (d < 2) {
            p1 = p.getNextPier(d);
            p2 = p.getNextPier(d ^ 2);
            if (p1 != null) {
                if (p2 != null) {
                    Bridge b = new Bridge(p1, p2);
                    this.setBridge(p2.getPos(), p1.getPos(), d, b);
                    p1.setBridge(d ^ 2, b);
                    p2.setBridge(d, b);
                    --this.nBridge;
                } else {
                    this.setBridge(p.getPos(), p1.getPos(), d, null);
                    p1.setBridge(d ^ 2, null);
                    --this.nBridge;
                }
            } else if (p2 != null) {
                this.setBridge(p.getPos(), p2.getPos(), d ^ 2, null);
                p2.setBridge(d, null);
                --this.nBridge;
            }
            ++d;
        }
        this.pier[r][c] = null;
        --this.nPier;
    }

    void setNBridge(int nBridge) {
        this.nBridge = nBridge;
    }

    int getNBridge() {
        return this.nBridge;
    }

    void setNPier(int nPier) {
        this.nPier = nPier;
    }

    int getNPier() {
        return this.nPier;
    }

    int getMaxChain() {
        return this.maxChain;
    }

    Pier findPier(int r, int c, int direction) {
        Address pos = Address.address(r, c);
        pos = pos.nextCell(direction);
        while (this.isOn(pos)) {
            if (this.isPier(pos)) {
                return this.pier[pos.r()][pos.c()];
            }
            pos = pos.nextCell(direction);
        }
        return null;
    }

    public void addBridge(int r, int c, int direction) {
        if (!this.isPier(r, c)) {
            return;
        }
        if (this.pier[r][c].getNextPier(direction) == null) {
            return;
        }
        if (this.pier[r][c].getNBridge(direction) == 2) {
            return;
        }
        this.pier[r][c].increaseBridge(direction);
        if (this.pier[r][c].getNBridge(direction) == 1) {
            this.connectChain(this.pier[r][c], this.pier[r][c].getNextPier(direction));
        }
    }

    public void addBridge(Address p, int d) {
        this.addBridge(p.r(), p.c(), d);
    }

    public void removeBridge(int r, int c, int direction) {
        if (!this.isPier(r, c)) {
            return;
        }
        if (this.pier[r][c].getNextPier(direction) == null) {
            return;
        }
        if (this.pier[r][c].getNBridge(direction) == 0) {
            return;
        }
        this.pier[r][c].decreaseBridge(direction);
        if (this.pier[r][c].getNBridge(direction) == 0) {
            this.cutChain(this.pier[r][c], this.pier[r][c].getNextPier(direction));
        }
    }

    public void removeBridge(Address p, int d) {
        this.removeBridge(p.r(), p.c(), d);
    }

    public void addBridgeA(Address pos, int direction) {
        this.addBridge(pos.r(), pos.c(), direction);
        this.fireUndoableEditUpdate(new BridgeEditStep(pos, direction, 1));
    }

    public void removeBridgeA(Address pos, int direction) {
        this.removeBridge(pos.r(), pos.c(), direction);
        this.fireUndoableEditUpdate(new BridgeEditStep(pos, direction, -1));
    }

    public void undo(AbstractStep step) {
        BridgeEditStep s = (BridgeEditStep)step;
        if (s.getChange() == 1) {
            this.removeBridge(s.getPos(), s.getDirection());
        } else if (s.getChange() == -1) {
            this.addBridge(s.getPos(), s.getDirection());
        }
    }

    public void redo(AbstractStep step) {
        BridgeEditStep s = (BridgeEditStep)step;
        if (s.getChange() == 1) {
            this.addBridge(s.getPos(), s.getDirection());
        } else if (s.getChange() == -1) {
            this.removeBridge(s.getPos(), s.getDirection());
        }
    }

    void initChain() {
        int c;
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c)) {
                    this.pier[r][c].setChain(0);
                }
                ++c;
            }
            ++r;
        }
        this.maxChain = 1;
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c)) {
                    if (this.pier[r][c].totalBridges() == 0) {
                        this.pier[r][c].setChain(0);
                    } else if (this.pier[r][c].getChain() == 0) {
                        this.initChain1(this.pier[r][c], this.maxChain++);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    void initChain1(Pier p, int chain) {
        if (p.getChain() == chain) {
            return;
        }
        p.setChain(chain);
        int d = 0;
        while (d < 4) {
            if (p.getNBridge(d) > 0) {
                this.initChain1(p.getNextPier(d), chain);
            }
            ++d;
        }
    }

    void connectChain(Pier pierA, Pier pierB) {
        int a = pierA.getChain();
        int b = pierB.getChain();
        if (a == 0) {
            if (b == 0) {
                pierA.setChain(this.maxChain);
                pierB.setChain(this.maxChain++);
            } else if (b > 0) {
                pierA.setChain(b);
            }
        } else if (a > 0) {
            if (b == 0) {
                pierB.setChain(a);
            } else if (b > 0) {
                this.initChain1(pierB, a);
            }
        }
    }

    void cutChain(Pier pierA, Pier pierB) {
        int a = pierA.totalBridges();
        int b = pierB.totalBridges();
        if (a == 0) {
            pierA.setChain(0);
            if (b == 0) {
                pierB.setChain(0);
            }
        } else if (a > 0) {
            if (b == 0) {
                pierB.setChain(0);
            } else if (b > 0) {
                this.initChain1(pierB, this.maxChain++);
            }
        }
    }

    public int checkPier(int r, int c) {
        int number = this.pier[r][c].getNumber();
        int bridges = this.pier[r][c].totalBridges();
        if (number == 9) {
            return 1;
        }
        return number - bridges;
    }

    public int checkAnswerCode() {
        int result = 0;
        if (!this.checkCross()) {
            result |= 1;
        }
        if (!this.checkConnection()) {
            result |= 2;
        }
        if (!this.checkNumbers()) {
            result |= 4;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(ERR_CROSS_BRIDGE);
        }
        if ((result & 2) == 2) {
            message.append(YET_MULTIPLE_LINE);
        }
        if ((result & 4) == 4) {
            message.append(ERR_WRONG_NUMBER);
        }
        return message.toString();
    }

    private boolean checkNumbers() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c) && this.pier[r][c].getNumber() != 9 && this.pier[r][c].totalBridges() != this.pier[r][c].getNumber()) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    private boolean checkConnection() {
        int n = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c)) {
                    int m = this.pier[r][c].getChain();
                    if (m == 0) {
                        return false;
                    }
                    if (n == 0) {
                        n = m;
                    } else if (n != m) {
                        return false;
                    }
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    private boolean checkCross() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.hasCrossedBridge(r, c)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    int sumAllNumbers() {
        int ret = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c)) {
                    ret += this.pier[r][c].getNumber();
                }
                ++c;
            }
            ++r;
        }
        return ret / 2;
    }
}

